%start expr
%union {
char* nPtr; };
%token <nPtr> IMPL PLUS MULT NOT L_BR R_BR LET NUM
%left PLUS
%left MULT
%right NOT
%left IMPL

%{
#include "DNF.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *rstring;

void copy_to_out(char*);

%}

%%
expr: 	expr MULT {copy_to_out($2);} expr  
		|expr PLUS {copy_to_out($2);} expr
		|expr IMPL {copy_to_out($2);} expr
		|NOT {copy_to_out($1);} expr
		|L_BR {copy_to_out("(");} expr R_BR {copy_to_out(")");}
		|NUM {copy_to_out($1);}
		|LET {copy_to_out($1);}
		;
	
%%
yyerror(char* s)
{ 
 printf("\nSyntax error\n");
/* exit(1);*/
}

void copy_to_out(char *str)
{
	if(!rstring)
	rstring = (char*)malloc(256);
	strcpy(rstring+strlen(rstring),str);
}

main()
{
 yyparse();
 rstring=input_string(rstring);
}
