%{
#define IMPL 258
#define PLUS 259
#define MULT 260
#define NOT 261
#define L_BR 262
#define R_BR 263
#define LET 264
#define NUM 265

extern int line;
extern int $1;
char* lex;
typedef union //define stack of value and YYSTYPE
	{
		char* nPtr;
	} YYSTYPE;
extern YYSTYPE yylval;

%}


LET  [a-z]
NUM [01]

%%
{LET}				{yyset(yytext); return LET;}
{NUM}				{yyset(yytext); return NUM;}
"->"            		{yyset(yytext); return IMPL;}
"+"             		{yyset(yytext); return PLUS;}
"*"            			{yyset(yytext); return MULT;}
"!"				{yyset(yytext); return NOT;}
\(              		{yyset("("); return L_BR;}
\)              		{yyset(")"); return R_BR;}
" "				{};
[ \r\t]     			{};
.				{printf("Warning:\nThere are unneedbl symbols.\n");}


%%
int yyset(char* str)
{
	lex=(char*)malloc(yyleng+1);
	strcpy(lex,yytext);
	yylval.nPtr=lex;
}
