/* This file is part of Crypt Library Demo application developed by Mihai MOGA.

Image Converter is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Open
Source Initiative, either version 3 of the License, or any later version.

Image Converter is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
Crypt Library Demo.  If not, see <http://www.opensource.org/licenses/gpl-3.0.html>*/

// CryptLibraryDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CryptLibraryDemo.h"
#include "CryptLibraryDemoDlg.h"
#include "CryptographyExt.h"
#include "VersionInfo.h"
#include "HyperlinkStatic.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

///////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
///////////////////////////////////////////////////////////////////////////////

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
public:
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();

protected:
	CFont m_fontCourier;
	CStatic m_ctrlVersion;
	CEdit m_ctrlWarning;
	CVersionInfo m_pVersionInfo;
	CHyperlinkStatic m_ctrlWebsite;
	CHyperlinkStatic m_ctrlEmail;

	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_VERSION, m_ctrlVersion);
	DDX_Control(pDX, IDC_WARNING, m_ctrlWarning);
	DDX_Control(pDX, IDC_WEBSITE, m_ctrlWebsite);
	DDX_Control(pDX, IDC_EMAIL, m_ctrlEmail);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	ON_WM_DESTROY()
END_MESSAGE_MAP()

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	if (m_pVersionInfo.Load(AfxGetApp()->m_pszExeName))
	{
		CString strName = m_pVersionInfo.GetProductName();
		CString strVersion = m_pVersionInfo.GetProductVersionAsString();
		strVersion.Replace(_T(" "), _T(""));
		strVersion.Replace(_T(","), _T("."));
		const int nFirst = strVersion.Find(_T('.'));
		const int nSecond = strVersion.Find(_T('.'), nFirst + 1);
		strVersion.Truncate(nSecond);
		m_ctrlVersion.SetWindowText(strName + _T(" version ") + strVersion);
	}

	// set up window's terminal fixed font
	LOGFONT logfont;
	memset(&logfont, 0, sizeof(logfont));
	logfont.lfCharSet = OEM_CHARSET;
	logfont.lfPitchAndFamily = FIXED_PITCH;
//	logfont.lfQuality = ANTIALIASED_QUALITY;
	logfont.lfOutPrecision = OUT_TT_PRECIS;
	logfont.lfWeight = FW_NORMAL;
	logfont.lfHeight = 10;
	_tcscpy_s(logfont.lfFaceName, LF_FACESIZE, _T("Tahoma"));
	VERIFY(m_fontCourier.CreateFontIndirect(&logfont));

	m_ctrlWarning.SetFont(&m_fontCourier);
	m_ctrlWarning.SetWindowText(_T("THE SOFTWARE IS PROVIDED \"AS-IS\" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL MIHAI MOGA BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE."));

	m_ctrlWebsite.SetHyperlink(_T("http://www.mihaimoga.com/"));
	m_ctrlEmail.SetHyperlink(_T("mailto:contact@mihaimoga.com"));

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CAboutDlg::OnDestroy()
{
	CDialog::OnDestroy();

	VERIFY(m_fontCourier.DeleteObject());
}

///////////////////////////////////////////////////////////////////////////////
// CCryptLibraryDemoDlg dialog
///////////////////////////////////////////////////////////////////////////////

CCryptLibraryDemoDlg::CCryptLibraryDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCryptLibraryDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCryptLibraryDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_FILENAME, m_editFilename);
	DDX_Control(pDX, IDC_CHECKSUM, m_editChecksum);
	DDX_Control(pDX, IDC_INPUTNAME, m_editInputName);
	DDX_Control(pDX, IDC_OUTPUTNAME, m_editOutputName);
	DDX_Control(pDX, IDC_COMPUTE, m_btnCompute);
	DDX_Control(pDX, IDC_ENCRYPT, m_btnEncrypt);
	DDX_Control(pDX, IDC_DECRYPT, m_btnDecrypt);
}

BEGIN_MESSAGE_MAP(CCryptLibraryDemoDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SELECT, &CCryptLibraryDemoDlg::OnBnClickedSelect)
	ON_BN_CLICKED(IDC_COMPUTE, &CCryptLibraryDemoDlg::OnBnClickedCompute)
	ON_BN_CLICKED(IDC_INPUTFILE, &CCryptLibraryDemoDlg::OnBnClickedInputfile)
	ON_BN_CLICKED(IDC_OUTPUTFILE, &CCryptLibraryDemoDlg::OnBnClickedOutputfile)
	ON_BN_CLICKED(IDC_ENCRYPT, &CCryptLibraryDemoDlg::OnBnClickedEncrypt)
	ON_BN_CLICKED(IDC_DECRYPT, &CCryptLibraryDemoDlg::OnBnClickedDecrypt)
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////////////////
// CCryptLibraryDemoDlg message handlers
///////////////////////////////////////////////////////////////////////////////

BOOL CCryptLibraryDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

#ifdef _DEBUG
	CString strBuffer1 = _T("abc"), strResult1;
	VERIFY(GetChecksumString(CALG_MD5, strResult1, strBuffer1));
	TRACE(_T("MD5(%s) => %s\n"), strBuffer1, strResult1);

	CString strBuffer2 = _T("abc"), strResult2;
	VERIFY(GetChecksumFile(CALG_SHA1, strResult2, _T("D:\\AddressBook.csv")));
	TRACE(_T("SHA1(%s) => %s\n"), strBuffer2, strResult2);

	CString strSecretKey = GetComputerID();
	LPBYTE lpszSecretKey = (LPBYTE)(LPCTSTR)strSecretKey;
	DWORD dwSecretKey = (strSecretKey.GetLength() + 1) * sizeof(TCHAR);
	CString strFilename = _T("D:\\AddressBook.csv");
	CString strEncrypt = _T("D:\\AddressBook.rc4");
	CString strDecrypt = _T("D:\\AddressBook.txt");
	VERIFY(EncryptFile(CALG_RC4, strEncrypt, strFilename, lpszSecretKey, dwSecretKey));
	VERIFY(DecryptFile(CALG_RC4, strDecrypt, strEncrypt, lpszSecretKey, dwSecretKey));
#endif

	CRect rectCryptLibraryDemo;
	GetClientRect(&rectCryptLibraryDemo);
	TRACE(_T("[CCryptLibraryDemoDlg] Width = %d, Height = %d\n"),
		rectCryptLibraryDemo.Width(), rectCryptLibraryDemo.Height());

	m_btnCompute.EnableWindow(FALSE);
	m_btnEncrypt.EnableWindow(FALSE);
	m_btnDecrypt.EnableWindow(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCryptLibraryDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCryptLibraryDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCryptLibraryDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CCryptLibraryDemoDlg::OnBnClickedSelect()
{
	DWORD dwFlags = OFN_DONTADDTORECENT | OFN_ENABLESIZING | OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_LONGNAMES;
	LPCTSTR lpszFilter = _T("All files (*.*)|*.*\0");
	CFileDialog pFileDialog(TRUE, NULL, NULL, dwFlags, lpszFilter, this);
	if (pFileDialog.DoModal() == IDOK)
	{
		m_strFilename = pFileDialog.GetPathName();
		m_editFilename.SetWindowText(m_strFilename);
		m_btnCompute.EnableWindow(!m_strFilename.IsEmpty());
	}
}

void CCryptLibraryDemoDlg::OnBnClickedCompute()
{
	CString strResult;
	if (!m_strFilename.IsEmpty())
	{
		if (GetChecksumFile(CALG_MD5, strResult, m_strFilename))
		{
			m_editChecksum.SetWindowText(strResult);
			MessageBox(_T("MD5 checksum of selected file is ready!"), _T("Crypt Library Demo"), MB_OK);
		}
	}
}

void CCryptLibraryDemoDlg::OnBnClickedInputfile()
{
	DWORD dwFlags = OFN_DONTADDTORECENT | OFN_ENABLESIZING | OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_LONGNAMES;
	LPCTSTR lpszFilter = _T("All files (*.*)|*.*\0");
	CFileDialog pFileDialog(TRUE, NULL, NULL, dwFlags, lpszFilter, this);
	if (pFileDialog.DoModal() == IDOK)
	{
		m_strInputName = pFileDialog.GetPathName();
		m_editInputName.SetWindowText(m_strInputName);
		m_btnEncrypt.EnableWindow(!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty());
		m_btnDecrypt.EnableWindow(!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty());
	}
}

void CCryptLibraryDemoDlg::OnBnClickedOutputfile()
{
	DWORD dwFlags = OFN_DONTADDTORECENT | OFN_ENABLESIZING | OFN_EXPLORER | OFN_HIDEREADONLY | OFN_LONGNAMES;
	LPCTSTR lpszFilter = _T("All files (*.*)|*.*\0");
	CFileDialog pFileDialog(FALSE, NULL, NULL, dwFlags, lpszFilter, this);
	if (pFileDialog.DoModal() == IDOK)
	{
		m_strOutputName = pFileDialog.GetPathName();
		m_editOutputName.SetWindowText(m_strOutputName);
		m_btnEncrypt.EnableWindow(!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty());
		m_btnDecrypt.EnableWindow(!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty());
	}
}

void CCryptLibraryDemoDlg::OnBnClickedEncrypt()
{
	CString strSecretKey = GetComputerID();
	LPBYTE lpszSecretKey = (LPBYTE)(LPCTSTR)strSecretKey;
	DWORD dwSecretKey = (strSecretKey.GetLength() + 1) * sizeof(TCHAR);
	if (!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty())
	{
		if (EncryptFile(CALG_RC4, m_strOutputName, m_strInputName, lpszSecretKey, dwSecretKey))
		{
			MessageBox(_T("The file have been successfully encrypted!"), _T("Crypt Library Demo"), MB_OK);
		}
	}
}

void CCryptLibraryDemoDlg::OnBnClickedDecrypt()
{
	CString strSecretKey = GetComputerID();
	LPBYTE lpszSecretKey = (LPBYTE)(LPCTSTR)strSecretKey;
	DWORD dwSecretKey = (strSecretKey.GetLength() + 1) * sizeof(TCHAR);
	if (!m_strInputName.IsEmpty() && !m_strOutputName.IsEmpty())
	{
		if (EncryptFile(CALG_RC4, m_strOutputName, m_strInputName, lpszSecretKey, dwSecretKey))
		{
			MessageBox(_T("The file have been successfully decrypted!"), _T("Crypt Library Demo"), MB_OK);
		}
	}
}
