////////////////////////////////////////////
//	Author: Romulo do Nascimento Ferreira //
//  Email: romulo.nf@gmail.com			  //
////////////////////////////////////////////

/* parametros

	tabelaID: id da tabela que vai ter funcionalidade de grid
	maxLinha: nmero mximo de linhas a ser mostrado (para criao de barra de rolagem)
	edicao: array que determina o mtodo de edio de cada coluna
		edicao.metodo: 
			default = edicao livre
			null = sem edicao
			array de string = opcoes da combo box
		edicao.unico:
			index = indica exclusividade de uma opcao de index x
	valor: array que determina qual elemento vai compor o array valores[] do grid
		default = conteudo da coluna
		null = nenhum valor atribuido
		tag = atribui ao array o conteudo da tag escolhida dentro da coluna
			ex: span
	largura: array com a porcentagem de largura de cada coluna
	alinhamento: array que determina o alinhamento de cada coluna (left,right,center,justify)
	fn: funo chamada pelo botao de adicionar na parte inferior do grid
	
*/

function criarGrid(tabelaID,maxLinha,edicao,valor,largura,alinhamento,fn) {

this.tempInputs = new Array()
this.tabela = document.getElementById(tabelaID)
this.tabela.className = "grid"
this.cabecalho = this.tabela.tHead
this.numCol = this.cabecalho.rows[0].cells.length
this.corpo = this.tabela.tBodies[0]
this.tamMax = this.corpo.rows.length > 0 ? (maxLinha * this.corpo.rows[0].offsetHeight) : maxLinha * 20
this.holder = this.tabela.parentNode
this.alturaCabecalho = this.cabecalho.rows[0].offsetHeight
this.opcoes = false
this.protecao = false
this.larguraCol = typeof largura !="undefined" ? largura : null
this.alignCol = typeof alinhamento !="undefined" ? alinhamento : null

	if (edicao && edicao !=false) {
	this.metodoEdicao = typeof edicao.metodo !="undefined" ? edicao.metodo : null
	this.unicoEdicao = typeof edicao.unico !="undefined" ? edicao.unico : null
	}
	if (edicao == false) {
	this.bloquearEdicao = true
	}

if (valor) this.tagValor = typeof valor.tag !="undefined" ? valor.tag : null

this.organizarEstrutura(fn)
this.executarTarefas()
}

criarGrid.prototype.verificarTamanho = function() {
this.alturaLinhas = 0
	
	for (x=0; x<this.novoCorpo.rows.length; x++) { this.alturaLinhas += this.novoCorpo.rows[x].offsetHeight }
	
	this.divHolder.style.height = this.alturaLinhas < this.tamMax ? this.alturaLinhas + "px" : this.tamMax + "px"
}

criarGrid.prototype.associarValores = function() {
	if (!this.valores) this.valores = new Array()
	
	if (this.valores.length > this.novoCorpo.rows.length) this.valores = new Array()

	for (x=0; x<this.novoCorpo.rows.length; x++) {
		this.valores[x] = new Array()
		for (y=0; y<this.numCol; y++) {
			if (this.tagValor[y] != "default") {
			tag = this.novoCorpo.rows[x].cells[y].getElementsByTagName(this.tagValor[y])
			tag.length > 0 ? conteudo = tag[0].innerHTML : conteudo = null
			}
			else { conteudo = this.novoCorpo.rows[x].cells[y].innerHTML }
			
			if (this.tagValor[y] != "undefined" || this.tagValor[y] != null) { this.valores[x][y] = conteudo }
		}
	}
}

criarGrid.prototype.funcoesTr = function() {
	for (x=0; x<this.novoCorpo.rows.length; x++) {
	this.novoCorpo.rows[x].grid = this
	 
		// zebraRows
		x%2 == 0 ? this.novoCorpo.rows[x].className = "par" : this.novoCorpo.rows[x].className = "impar"
		 
		// mouseover event
	 	this.novoCorpo.rows[x].onmouseover = function() {
		if (this.grid.timer) clearTimeout(this.grid.timer)
		this.grid.mostrarOpcoes(this)
		this.className += " hover" 
		}
	
		// mouseout event
		this.novoCorpo.rows[x].onmouseout = function() {
		var _this = this.grid
		this.grid.timer = setTimeout(function(){_this.removerOpcoes()},500)
		this.className = this.className.substring(0,this.className.indexOf(" hover")) 
		}

	}
}

criarGrid.prototype.criarOverlay = function() {
if (this.protecao) this.removerOverlay()
this.protecao = true
this.overlay = document.createElement("div")
this.overlay.className = "overlay"
this.overlay.style.height = this.divHolder.offsetHeight + 10 + "px"
this.overlay.style.width = this.novaTabela.offsetWidth + 10 + "px"
this.overlay.style.top = this.divHolder.offsetTop + this.tabela.offsetTop + this.alturaCabecalho + "px"
this.overlay.style.left = this.divHolder.offsetLeft + this.tabela.offsetLeft + "px"
this.holder.appendChild(this.overlay)

this.divHolder.style.overflow = "hidden"
this.botaoAdicionar.style.display = "none"
}

criarGrid.prototype.removeOverlay = function() {
this.overlay.parentNode.removeChild(this.overlay)
this.protecao = false

this.divHolder.style.overflow = "auto"
this.botaoAdicionar.style.display = ""
}

criarGrid.prototype.editarLinha = function(tr) {
this.removerOpcoes()
this.criarOverlay()

	this.edicaoTable = document.createElement("table")
	this.edicaoTable.className = "edicaoTable"
	this.edicaoTbody = document.createElement("tbody")
	this.cloneTr = tr.cloneNode(true)
	this.edicaoTable.appendChild(this.edicaoTbody)
	this.edicaoTbody.appendChild(this.cloneTr)

	this.edicaoTable.style.width = tr.offsetWidth + "px"
	this.edicaoTable.style.top = tr.offsetTop - this.divHolder.scrollTop + this.tabela.offsetTop + this.alturaCabecalho + "px"
	this.edicaoTable.style.left = this.tabela.offsetLeft - this.divEdicaoTr.offsetWidth + "px"
	
	// metodos de edicao
	for (x=0; x<this.cloneTr.cells.length; x++) {
	this.cloneTr.cells[x].style.width = tr.cells[x].offsetWidth + "px"

		if (this.metodoEdicao[x] == "default") {
		this.tempInputs[x] = document.createElement("input")
		this.tempInputs[x].value = tr.cells[x].innerHTML
		this.cloneTr.cells[x].replaceChild(this.tempInputs[x],this.cloneTr.cells[x].childNodes[0])
		}

		else if (this.metodoEdicao[x] && this.metodoEdicao[x].length > 1) {
		this.tempInputs[x] = document.createElement("select")
			for (y=0; y<this.metodoEdicao[x].length; y++) {
			opcaoTemp = document.createElement("option")
			opcaoTemp.value = this.metodoEdicao[x][y]
			opcaoTemp.innerHTML = this.metodoEdicao[x][y]
			this.tempInputs[x].appendChild(opcaoTemp)
			}
		this.cloneTr.cells[x].replaceChild(this.tempInputs[x],this.cloneTr.cells[x].childNodes[0])
		
			for (y=0; y<this.tempInputs[x].options.length; y++) {
				if (this.tempInputs[x].options[y].innerHTML.toLowerCase() == tr.cells[x].innerHTML.toLowerCase()) {
				this.tempInputs[x].options[y].selected = "selected"
				}
			}
		}
		
		else {
		this.tempInputs[x] = document.createElement("input")
		this.tempInputs[x].value = tr.cells[x].innerHTML
		this.tempInputs[x].disabled = "disabled"
		this.cloneTr.cells[x].replaceChild(this.tempInputs[x],this.cloneTr.cells[x].childNodes[0])
		}

	}
	
	this.holder.appendChild(this.edicaoTable)
	
	this.botaoAceitar = new Image()
	this.botaoAceitar.src = "img/aceitar.gif"
	this.botaoAceitar.className = "botaoAceitar"
	this.botaoAceitar.grid = this
	this.botaoAceitar.onclick = function() { this.grid.aceitarEdicao(tr) }
	this.botaoAceitar.style.top = parseInt(this.edicaoTable.style.top) + this.edicaoTable.offsetHeight/6 + "px"
	this.botaoAceitar.style.left = parseInt(this.edicaoTable.style.left) + this.edicaoTable.offsetWidth + 3 + "px"
	this.holder.appendChild(this.botaoAceitar)
	
	this.botaoCancelar = new Image()
	this.botaoCancelar.src = "img/cancelar.gif"
	this.botaoCancelar.className = "botaoCancelar"
	this.botaoCancelar.grid = this
	this.botaoCancelar.onclick = function() { this.grid.cancelarEdicao() }
	this.botaoCancelar.style.top = parseInt(this.botaoAceitar.style.top) + "px"
	this.botaoCancelar.style.left = parseInt(this.edicaoTable.style.left) + this.edicaoTable.offsetWidth + 20 + "px"
	this.holder.appendChild(this.botaoCancelar)	
}

criarGrid.prototype.aceitarEdicao = function(tr) {

	for (x=0; x<this.tempInputs.length; x++) {
		if (this.unicoEdicao[x] && this.tempInputs[x].value != this.metodoEdicao[x][this.unicoEdicao[x]]) {
			for (y=0; y<this.novoCorpo.rows.length; y++) {
			this.novoCorpo.rows[y].cells[x].innerHTML = this.metodoEdicao[x][this.unicoEdicao[x]]
			}
		}
	tr.cells[x].innerHTML = this.tempInputs[x].value 
	}
	
this.cancelarEdicao()
this.executarTarefas()
}

criarGrid.prototype.cancelarEdicao = function() {
this.removeOverlay()
this.edicaoTable.parentNode.removeChild(this.edicaoTable)
this.botaoCancelar.parentNode.removeChild(this.botaoCancelar)
this.botaoAceitar.parentNode.removeChild(this.botaoAceitar)
}

criarGrid.prototype.excluirLinha = function(tr) {
this.removerOpcoes()
tr.parentNode.removeChild(tr)
this.executarTarefas()
}

criarGrid.prototype.removerOpcoes = function() {
if (this.divEdicaoTr) this.divEdicaoTr.parentNode.removeChild(this.divEdicaoTr)
this.opcoes = false
}

criarGrid.prototype.mostrarOpcoes = function(tr) {
if (this.opcoes) this.removerOpcoes()

this.opcoes = true

this.divEdicaoTr = document.createElement("div")
this.divEdicaoTr.className = "divEdicao"
this.divEdicaoTr.grid = this

	this.divEdicaoTr.onmouseover = function() { if (this.grid.timer) clearTimeout(this.grid.timer) }
	this.divEdicaoTr.onmouseout = function() {
	var _this = this.grid
	this.grid.timer = setTimeout(function(){_this.removerOpcoes()},500)
	}
	
this.holder.appendChild(this.divEdicaoTr)

if (!this.bloquearEdicao) {
this.botaoEditar = new Image()
this.botaoEditar.grid = this
this.botaoEditar.alt = "Clique aqui para editar a linha " + (tr.rowIndex + 1)
this.botaoEditar.title = "Clique aqui para editar a linha " + (tr.rowIndex + 1)
this.botaoEditar.onclick = function() { this.grid.editarLinha(tr) }
this.botaoEditar.src = "img/lapis.gif"
this.divEdicaoTr.appendChild(this.botaoEditar)
}

this.botaoExcluir = new Image()
this.botaoExcluir.grid = this
this.botaoExcluir.alt = "Clique aqui para excluir a linha " + (tr.rowIndex + 1)
this.botaoExcluir.title = "Clique aqui para excluir a linha " + (tr.rowIndex + 1)
this.botaoExcluir.onclick = function() { this.grid.excluirLinha(tr) }
this.botaoExcluir.src = "img/lixeira.gif"
this.divEdicaoTr.appendChild(this.botaoExcluir)

this.divEdicaoTr.style.top = tr.offsetTop - this.divHolder.scrollTop + this.tabela.offsetTop + this.alturaCabecalho + "px"
this.divEdicaoTr.style.left = tr.offsetWidth + this.tabela.offsetLeft - this.divEdicaoTr.offsetWidth + "px"
}

criarGrid.prototype.executarTarefas = function() {
this.corrigirLargura()
this.funcoesTr()
this.associarValores()
this.verificarTamanho()
}

criarGrid.prototype.corrigirLargura = function() {
	for (x=0; x<this.numCol; x++) {
	if (this.larguraCol) { this.cabecalho.rows[0].cells[x].style.width = this.larguraCol[x] + "%" }
		for (y=0; y<this.novoCorpo.rows.length; y++) {
		if (this.larguraCol) { this.novoCorpo.rows[y].cells[x].style.width = this.larguraCol[x] + "%" }
		if (this.alignCol) { this.novoCorpo.rows[y].cells[x].style.textAlign = this.alignCol[x] }
		}
	}
}

criarGrid.prototype.organizarEstrutura = function(fn) {
	this.scrollBar = document.createElement("th")
	this.trHolder = document.createElement("tr")
	this.tdHolder = document.createElement("td")
	this.divHolder = document.createElement("div")
	this.novaTabela = document.createElement("table")
	this.novoCorpo = document.createElement("tbody")

	while (this.corpo.rows.length > 0) { this.novoCorpo.appendChild(this.corpo.rows[0]) }

	this.scrollBar.innerHTML = "&nbsp;"
	this.scrollBar.className = "scrollBar"
	this.cabecalho.rows[0].appendChild(this.scrollBar)
		
	this.corpo.appendChild(this.trHolder)
	
	this.tdHolder.colSpan = (this.numCol+1)
	this.trHolder.appendChild(this.tdHolder)
	
	this.divHolder.className = "holder"
	this.divHolder.style.height = this.tamMax + "px"
	this.tdHolder.appendChild(this.divHolder)
	
	this.divHolder.appendChild(this.novaTabela)
	
	this.novaTabela.appendChild(this.novoCorpo)
	
	this.botaoAdicionar = new Image()
	this.botaoAdicionar.onmouseover = function() { this.src = "img/add2-hover.gif" }
	this.botaoAdicionar.onmouseout = function() { this.src = "img/add2.gif" } 
	this.botaoAdicionar.className = "botaoAdicionar"
	this.botaoAdicionar.src = "img/add2.gif"
	this.botaoAdicionar.onclick = function() { eval(fn) }
	this.holder.insertBefore(this.botaoAdicionar,this.tabela.nextSibling)
}

criarGrid.prototype.importarDados = function(tr) {

inserirTr = true

	for (x=0; x<this.novoCorpo.rows.length; x++) {
		conteudoAtual = this.novoCorpo.rows[x].textContent ? this.novoCorpo.rows[x].textContent : this.novoCorpo.rows[x].innerText
		conteudoNovo = tr.textContent ? tr.textContent : tr.innerText
		if (conteudoAtual == conteudoNovo) { inserirTr = false }
	}
	
	if (inserirTr) {

	this.novoCorpo.insertRow(this.novoCorpo.rows.length)
	
		for (x=0; x<this.numCol; x++) {
		this.novoCorpo.rows[this.novoCorpo.rows.length-1].insertCell(x)
		this.novoCorpo.rows[this.novoCorpo.rows.length-1].cells[x].innerHTML = tr.getElementsByTagName("td")[x].innerHTML
		}
		
	this.divHolder.scrollTop = this.divHolder.scrollHeight

	this.executarTarefas()
	}
	
	else { janela.alert("Informao existente") }
}