////////////////////////////////////////////
//	Author: Romulo do Nascimento Ferreira //
//  Email: romulo.nf@gmail.com			  //
////////////////////////////////////////////

/* parameters

	tableID: id da coluna que vai utilizar filtragem
	numRows: nmero mximo de linhas a serem mostradas
	width: array com o tamanho de cada coluna (em %)
		*para melhor ajuste trabalhar com soma do array = 100
	align: determina o alinhamento de cada coluna (left,right,center,justify)
	allowFilter: array que determina quais colunas vao possuir filtro (true/false)
	allowTip: array que determina quais colunas vao possuir tooltip (true/false)

*/

function createFilter(tableID,numRows,width,align,allowFilter,allowTip,gridInstance) {
this.pageBody = document.getElementsByTagName("body")[0]
this.table = document.getElementById(tableID)
this.table.className = "filter"
this.header = this.table.tHead
this.mainBody = this.table.tBodies[0]
this.numCol = this.header.rows[0].cells.length
this.totalWidth = 0
this.maxRows = numRows
this.selectArray = new Array(this.numCol)
this.optionArray = new Array(this.numCol)
this.tipInit = false
this.gridInstance = eval("opener." + gridInstance) || false

// create an extra tr beneath the header
this.newTr = document.createElement("tr")
this.header.appendChild(this.newTr)

	// calc the total width of the table
	for (x=0; x<width.length; x++) { this.totalWidth += width[x] }

	for (x=0; x<this.numCol; x++) {
	// loop to create the ths
	tempTh = document.createElement("th")
	this.newTr.appendChild(tempTh)
	
	// create one select box to each th
	tempSelect = document.createElement("select")
	if (!allowFilter[x]) {
	tempSelect.disabled = "disabled"
	tempSelect.style.background = "#eee"
	}
	tempSelect.style.width = "100%"
	tempSelect.ativado = false
	tempSelect.filtro = this
	tempSelect.onchange = function() { this.filtro.applyFilter(this) }
	this.selectArray[x] = tempSelect
	tempTh.appendChild(tempSelect)
	}
	
	for (x=0; x<this.header.rows.length; x++) {
	// create an extra th to allow the scrolling
	tempTh = document.createElement("th")
	tempTh.className = "scrollBar"
	this.header.rows[x].appendChild(tempTh)
	}
	
	// change the table normal structure to allow the scroll
	tempTr = document.createElement("tr")
	tempTd = document.createElement("td")
	divHolder = document.createElement("div")
	tempTable = document.createElement("table")
	this.newBody = document.createElement("tbody")
	
	while (this.mainBody.rows.length > 0) { this.newBody.appendChild(this.mainBody.rows[0]) }
	
	//for (x=this.mainBody.rows.length-1; x>=0; x--) { this.newBody.appendChild(this.mainBody.rows[x]) }

	tempTd.colSpan = this.numCol + 1
	divHolder.className = "holder"

	this.mainBody.appendChild(tempTr)
	tempTr.appendChild(tempTd)
	tempTd.appendChild(divHolder)
	divHolder.appendChild(tempTable)
	tempTable.appendChild(this.newBody)
	
	this.tamanhoPermitido = numRows * this.newBody.rows[0].cells[0].offsetHeight
	divHolder.style.height = this.tamanhoPermitido + "px"

	for (x=0; x<this.numCol; x++) {
		this.header.rows[0].cells[x].style.width = width[x] + "%"
		
		for (y=0; y<this.newBody.rows.length; y++) {
		this.newBody.rows[y].cells[x].filtro = this
		
		if (allowTip[x]) {
		this.newBody.rows[y].cells[x].onmouseover = function(e) { this.filtro.showTip(this,e) }
		this.newBody.rows[y].cells[x].onmouseout = function(e) { this.filtro.showTip(this,e) }
		}
		
		this.newBody.rows[y].cells[x].style.width = width[x] + "%"
		this.newBody.rows[y].cells[x].style.textAlign = align[x]
		}
	}

	this.populateFilters()
}

createFilter.prototype.showTip = function(td,e) {
if (!e) e = window.event
this.target = e.target ? e.target : e.srcElement

	if (this.target.tagName !="td") { this.target = this.target.parentNode }

	if (e.type == "mouseout" && this.tipInit) { 
	this.tip.parentNode.removeChild(this.tip)
	this.tipInit = false
	}
	
	else {
	this.tipInit = true
	this.posY = e.pageY ? e.pageY : e.clientY ? e.clientY + this.pageBody.scrollTop : null
	
	this.tip = document.createElement("div")

	this.tip.filtro = this
	this.tip.onmouseover = function() { 
	this.parentNode.removeChild(this)
	this.filtro.tipInit = false
	}
	
	this.tip.innerHTML = td.innerHTML
	this.tip.className = "tip"
	this.tip.style.top = this.table.offsetTop + this.table.offsetHeight + "px"
	this.tip.style.left = this.table.offsetLeft + "px"
	this.tip.style.width = this.table.offsetWidth + "px"
	this.pageBody.appendChild(this.tip)
	}
}

createFilter.prototype.populateFilters = function() {

	for (x=0; x<this.numCol; x++) {
	
	tempOptionArray = new Array()
	count = 0
	
	// clear all the options from the selects
		if (this.selectArray[x].options.length > 0) {
			for (y=this.selectArray[x].options.length-1; y>=0; y--) {
			this.selectArray[x].remove(y)
			}
		}
		
		// search through all visible rows and populate an array with all the possibilities
		for (y=0; y<this.newBody.rows.length; y++) {
			if (this.newBody.rows[y].style.display !="none") {
			tempOptionArray[count] = this.newBody.rows[y].cells[x].innerHTML
			count = count + 1
			}
		}
		
		// sort this array
//		tempOptionArray.sort()
//		
		// remove all repeated entries
//		for (y=tempOptionArray.length-1; y>=1; y--) {
//			if (tempOptionArray[y] == tempOptionArray[y-1]) { tempOptionArray.splice(y,1) }
//		}

		optionArray = tempOptionArray.unique()
	
		// create a blank option to remove the filter
		blankOption = document.createElement("option")
		blankOption.innerHTML = "Todos"
		blankOption.value = ""
		this.selectArray[x].appendChild(blankOption)
		
		// loop the array and populate the select box
		for (y=0; y<optionArray.length; y++) {
		newOption = document.createElement("option")
		newOption.innerHTML = optionArray[y]
		newOption.value = optionArray[y]
		this.selectArray[x].appendChild(newOption)
			if (this.selectArray[x].ativado) { this.selectArray[x].options[1].selected = "selected"	}
		}
	}
	
	tempContador = 0
	for (x=0; x<this.newBody.rows.length; x++) {
		if (this.newBody.rows[x].style.display !="none") { tempContador = tempContador + this.newBody.rows[x].offsetHeight }
	}
	
	if (divHolder.offsetHeight > tempContador) { divHolder.style.height = tempContador + "px" }
	
	else { divHolder.style.height = this.tamanhoPermitido + "px" }
		
	this.zebraRows()
}

createFilter.prototype.applyFilter = function(filtro) {
cellIndex = filtro.parentNode.cellIndex
appliedFilter = filtro.value

appliedFilter != "" ? filtro.ativado = true : filtro.ativado = false

	// loop all rows and compare the innerHTML from the tds with the filter
	// hide the tds that dont match the filter
	for (x=0; x<this.newBody.rows.length; x++) {
		this.newBody.rows[x].flag = false
		for (y=0; y<this.numCol; y++) {
			if (this.newBody.rows[x].cells[y].innerHTML != this.selectArray[y].value && this.selectArray[y].value !="") {
			this.newBody.rows[x].flag = true
			}
		}
		this.newBody.rows[x].flag ? this.newBody.rows[x].style.display = "none" : this.newBody.rows[x].style.display = ""
	}

	this.populateFilters()
}

createFilter.prototype.zebraRows = function() {
this.nextClass = "odd"

	for (x=0; x<this.newBody.rows.length; x++) {
	this.newBody.rows[x].filtro = this
	if (this.gridInstance) this.newBody.rows[x].onclick = function() { this.filtro.gridInstance.importarDados(this) }
	this.newBody.rows[x].onmouseover = function() { this.className += " hover" }
	this.newBody.rows[x].onmouseout = function() { this.className = this.className.substring(0,this.className.indexOf(" hover")) }
	
		if (this.newBody.rows[x].style.display != "none") {
		this.newBody.rows[x].className = this.nextClass
		this.nextClass == "odd" ? this.nextClass = "even" : this.nextClass = "odd"
		}
	}
}

// remove todas as entradas duplicadas de um array
Array.prototype.unique = function( b ) {
 var a = [], i, l = this.length;
 for( i=0; i<l; i++ ) {
  if( a.indexOf( this[i], 0, b ) < 0 ) { a.push( this[i] ); }
 }
 return a;
};