﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Management;
using System.Media;

using AForge;
using AForge.Imaging;
using AForge.Imaging.Filters;
using AForge.Video;
using AForge.Video.DirectShow;

using Phidgets;
using Phidgets.Events;

namespace Robot
{
    public partial class MainForm : Form
    {
        #region(Load)

        private InterfaceKit ifKit;
        
        AdvancedServo servo = null; // Phidget servo controller

        static InterfaceKit ifKit1; //Declare an InterfaceKit object
        static InterfaceKit ifKit2; //Declare an InterfaceKit object
        static InterfaceKit ifKit3; //Declare an InterfaceKit object

        static AdvancedServo left_arm; //Declare an servo object
        static AdvancedServo right_arm; //Declare an servo object
        static AdvancedServo eyes_and_wheels; //Declare an servo object

        static Phidgets.Encoder encoder; //Declare an encoder object

        static Accelerometer accel; //Declare an accelerometer object

       Thread threadRE;
        Thread threadLW;
        Thread threadRW;
        // list of video devices
        FilterInfoCollection videoDevices;
        // form for cameras' movement
        MoveCamerasForm moveCamerasForm;
      
        ColorFiltering colorFilter = new ColorFiltering();
        GrayscaleBT709 grayFilter = new GrayscaleBT709();
        // use two blob counters, so the could run in parallel in two threads
        BlobCounter blobCounter1 = new BlobCounter();
        BlobCounter blobCounter2 = new BlobCounter();

        private AutoResetEvent camera1Acquired = null;
        private AutoResetEvent camera2Acquired = null;
        private Thread trackingThread = null;

        // object coordinates in both cameras
        private float x1, y1, x2, y2;

        private IntRange redRange = new IntRange(0, 255);
        private IntRange greenRange = new IntRange(0, 255);
        private IntRange blueRange = new IntRange(0, 255);

        

        public event EventHandler OnFilterUpdate;

        public MainForm()
        {
            InitializeComponent();

            // show device list
            try
            {
                // enumerate video devices
                videoDevices = new FilterInfoCollection(FilterCategory.VideoInputDevice);

                if (videoDevices.Count == 0)
                {
                    throw new Exception();
                }

                for (int i = 1, n = videoDevices.Count; i <= n; i++)
                {
                    string cameraName = i + " : " + videoDevices[i - 1].Name;

                    camera1Combo.Items.Add(cameraName);
                    camera2Combo.Items.Add(cameraName);
                }

                // check cameras count
                if (videoDevices.Count == 1)
                {
                    camera2Combo.Items.Clear();

                    camera2Combo.Items.Add("Only one camera found");
                    camera2Combo.SelectedIndex = 0;
                    camera2Combo.Enabled = false;
                }
                else
                {
                    camera2Combo.SelectedIndex = 1;
                }
                camera1Combo.SelectedIndex = 0;
            }
            catch
            {
                startButton.Enabled = false;

                camera1Combo.Items.Add("No cameras found");
                camera2Combo.Items.Add("No cameras found");

                camera1Combo.SelectedIndex = 0;
                camera2Combo.SelectedIndex = 0;

                camera1Combo.Enabled = false;
                camera2Combo.Enabled = false;
            }

            //
            colorFilter.Red = new IntRange(0, 100);
            colorFilter.Green = new IntRange(0, 200);
            colorFilter.Blue = new IntRange(150, 255);  
                  

            // configure blob counters
            blobCounter1.MinWidth = 25;
            blobCounter1.MinHeight = 25;
            blobCounter1.FilterBlobs = true;
            blobCounter1.ObjectsOrder = ObjectsOrder.Size;

            blobCounter2.MinWidth = 25;
            blobCounter2.MinHeight = 25;
            blobCounter2.FilterBlobs = true;
            blobCounter2.ObjectsOrder = ObjectsOrder.Size;
        }


        private void MainForm_Load(object sender, EventArgs e)
        {
            textBox2.Text = "www";
            colours();
            ifKit = new InterfaceKit();

            ifKit.Attach += new AttachEventHandler(ifKit_Attach);
            ifKit.Detach += new DetachEventHandler(ifKit_Detach);

            ifKit.InputChange += new InputChangeEventHandler(ifKit_InputChange);
            ifKit.OutputChange += new OutputChangeEventHandler(ifKit_OutputChange);
            ifKit.SensorChange += new SensorChangeEventHandler(ifKit_SensorChange);

            //Open the Phidget using the command line arguments
            openCmdLine(ifKit);

            servo = new AdvancedServo();

            servo.Attach += new AttachEventHandler(servo_Attach);
            servo.Detach += new DetachEventHandler(servo_Detach);
            servo.PositionChange += new PositionChangeEventHandler(servo_PositionChange);

            servo.open();

            ifKit1 = new InterfaceKit(); //Initialize the InterfaceKit1 object
            ifKit2 = new InterfaceKit(); //Initialize the InterfaceKit2 object
            ifKit3 = new InterfaceKit();//Initialize the InterfaceKit3 object

            left_arm = new AdvancedServo(); //Initialize the AdvancedServo object
            right_arm = new AdvancedServo(); //Initialize the AdvancedServo object
            eyes_and_wheels = new AdvancedServo(); //Initialize the AdvancedServo object

            accel = new Accelerometer(); //Initialize the Accelerometer object

            encoder = new Phidgets.Encoder(); //Initialize the Encoder object

            ifKit1.InputChange += new InputChangeEventHandler(ifKit1_InputChange);  //Hook the phidget spcific event handlers
            ifKit1.OutputChange += new OutputChangeEventHandler(ifKit1_OutputChange);  //Hook the phidget spcific event handlers
            ifKit1.SensorChange += new SensorChangeEventHandler(ifKit1_SensorChange);  //Hook the phidget spcific event handlers
            ifKit1.Error += new ErrorEventHandler(ifKit_Error);  //Hook the phidget spcific event handlers

            ifKit2.InputChange += new InputChangeEventHandler(ifKit2_InputChange);  //Hook the phidget spcific event handlers
            ifKit2.OutputChange += new OutputChangeEventHandler(ifKit2_OutputChange);  //Hook the phidget spcific event handlers
            ifKit2.SensorChange += new SensorChangeEventHandler(ifKit2_SensorChange);  //Hook the phidget spcific event handlers
            ifKit2.Error += new ErrorEventHandler(ifKit_Error);  //Hook the phidget spcific event handlers

            ifKit3.InputChange += new InputChangeEventHandler(ifKit3_InputChange);  //Hook the phidget spcific event handlers
            ifKit3.OutputChange += new OutputChangeEventHandler(ifKit3_OutputChange);  //Hook the phidget spcific event handlers
            ifKit3.SensorChange += new SensorChangeEventHandler(ifKit3_SensorChange);  //Hook the phidget spcific event handlers
            ifKit3.Error += new ErrorEventHandler(ifKit_Error);  //Hook the phidget spcific event handlers

            left_arm.PositionChange += new PositionChangeEventHandler(advServo_PositionChange);  //Hook the phidget spcific event handlers
            left_arm.VelocityChange += new VelocityChangeEventHandler(advServo_VelocityChange);  //Hook the phidget spcific event handlers
            left_arm.Error += new ErrorEventHandler(advServo_Error);  //Hook the phidget spcific event handlers

            right_arm.PositionChange += new PositionChangeEventHandler(advServo_PositionChange);  //Hook the phidget spcific event handlers
            right_arm.VelocityChange += new VelocityChangeEventHandler(advServo_VelocityChange);  //Hook the phidget spcific event handlers
            right_arm.Error += new ErrorEventHandler(advServo_Error);  //Hook the phidget spcific event handlers

            eyes_and_wheels.PositionChange += new PositionChangeEventHandler(advServo_PositionChange);  //Hook the phidget spcific event handlers
            eyes_and_wheels.VelocityChange += new VelocityChangeEventHandler(advServo_VelocityChange);  //Hook the phidget spcific event handlers
            eyes_and_wheels.Error += new ErrorEventHandler(advServo_Error);  //Hook the phidget spcific event handlers

            accel.Attach += new AttachEventHandler(accel_Attach);
            accel.AccelerationChange += new AccelerationChangeEventHandler(accel_AccelerationChange);  //Hook the phidget spcific event handlers
            accel.Error += new ErrorEventHandler(accel_Error);  //Hook the phidget spcific event handlers

            encoder.InputChange += new InputChangeEventHandler(encoder_InputChange);  //Hook the phidget spcific event handlers
            encoder.PositionChange += new EncoderPositionChangeEventHandler(encoder_PositionChange);  //Hook the phidget spcific event handlers

            accel.open(159431);
            ifKit1.open(117172); //Open the object for device connections
            ifKit2.open(100818);

            for (int i = 0; i < accel.axes.Count; i++)
            {
                accel.axes[i].Sensitivity = 1.10;
            }

            left_arm.open(170038);
            right_arm.open(99333);
            eyes_and_wheels.open(99364);

            Console.Read();  //Wait for user input so that we can wait and watch for some event data from the phidget

            ifKit1.close(); //User input was rad so we'll terminate the program, so close the object
            ifKit2.close(); //User input was rad so we'll terminate the program, so close the object
            ifKit3.close(); //User input was rad so we'll terminate the program, so close the object

            left_arm.close(); // close left_arm connection
            right_arm.close(); // close right_arm connection
            eyes_and_wheels.close(); // close eyes_and_wheels connection

            //Application.DoEvents();

            ifKit1 = null;  //set the object to null to get it out of memory
            ifKit2 = null;  //set the object to null to get it out of memory
            ifKit3 = null;  //set the object to null to get it out of memory

            left_arm = null; // clear left_arm from memory
            right_arm = null; // clear right_arm; from memory
            eyes_and_wheels = null; // clear eyes_and_wheels from memory

            accel.close(); // close accel connection

            accel = null; // clear accel from memory

            encoder.close(); // close encoder connection

            encoder = null; // clear encoder from memory
            
            

            //openCmdLine(stepper);

            StartCameras();
            colours();
            UpdateObjectPicture(0, null);
            UpdateObjectPicture(1, null);

            startButton.Enabled = false;
            stopButton.Enabled = true;

            OnFilterUpdate += new EventHandler(OnFilterUpdate);

            
        }
        

        //put colours into colour sider
        private void colours()
        {
            cboColour.SelectedIndex = 0;
            cboShape.SelectedIndex = 0;
            pbColour1.BackColor = Color.FromArgb(255, 255, 255);
            pbColour2.BackColor = Color.FromArgb(255, 255, 153);
            pbColour3.BackColor = Color.FromArgb(255, 255, 202);
            // 2
            pbColour4.BackColor = Color.FromArgb(255, 255, 204);
            pbColour5.BackColor = Color.FromArgb(255, 255, 51);
            pbColour6.BackColor = Color.FromArgb(255, 255, 0);
            //3
            pbColour7.BackColor = Color.FromArgb(255, 204, 102);
            pbColour8.BackColor = Color.FromArgb(255, 204, 51);
            pbColour9.BackColor = Color.FromArgb(255, 204, 0);
            //4
            pbColour10.BackColor = Color.FromArgb(255, 102, 102);
            pbColour11.BackColor = Color.FromArgb(255, 51, 102);
            pbColour12.BackColor = Color.FromArgb(255, 0, 0);
            // 5
            pbColour13.BackColor = Color.FromArgb(204, 255, 204);
            pbColour14.BackColor = Color.FromArgb(153, 255, 102);
            pbColour15.BackColor = Color.FromArgb(102, 255, 153);
            //6
            pbColour16.BackColor = Color.FromArgb(102, 255, 85);
            pbColour17.BackColor = Color.FromArgb(51, 255, 102);
            pbColour18.BackColor = Color.FromArgb(51, 204, 50);
            //7
            pbColour19.BackColor = Color.FromArgb(51, 173, 204);
            pbColour20.BackColor = Color.FromArgb(0, 153, 255);
            pbColour21.BackColor = Color.FromArgb(0, 80, 255);
            //8
            pbColour22.BackColor = Color.FromArgb(0, 60, 255);
            pbColour23.BackColor = Color.FromArgb(0, 0, 255);
            pbColour24.BackColor = Color.FromArgb(0, 0, 102);
            //9
            pbColour25.BackColor = Color.FromArgb(0, 0, 0);
        }

        private void button1_Click(object sender, EventArgs e)
        {

            disengage();
        }

        #endregion

        #region(sight)

        // On "Start" button click - start cameras
        private void startButton_Click(object sender, EventArgs e)
        {
            StartCameras();

            startButton.Enabled = false;
            stopButton.Enabled = true;
        }

        // On "Stop" button click - stop cameras
        private void stopButton_Click(object sender, EventArgs e)
        {
            StopCameras();

            startButton.Enabled = true;
            stopButton.Enabled = false;
        }

        // Start cameras
        private void StartCameras()
        {
            // create first video source
            VideoCaptureDevice videoSource1 = new VideoCaptureDevice(videoDevices[camera1Combo.SelectedIndex].MonikerString);
            videoSource1.DesiredFrameRate = 10;

            videoSourcePlayer1.VideoSource = videoSource1;
            videoSourcePlayer1.Start();

            // create second video source
            if (camera2Combo.Enabled == true)
            {
                System.Threading.Thread.Sleep(500);

                VideoCaptureDevice videoSource2 = new VideoCaptureDevice(videoDevices[camera2Combo.SelectedIndex].MonikerString);
                videoSource2.DesiredFrameRate = 10;

                videoSourcePlayer2.VideoSource = videoSource2;
                videoSourcePlayer2.Start();
            }

            camera1Acquired = new AutoResetEvent(false);
            camera2Acquired = new AutoResetEvent(false);
            // start tracking thread
            trackingThread = new Thread(new ThreadStart(TrackingThread));
            trackingThread.Start();
        }

        // Stop cameras
        private void StopCameras()
        {
            videoSourcePlayer1.SignalToStop();
            videoSourcePlayer2.SignalToStop();

            videoSourcePlayer1.WaitForStop();
            videoSourcePlayer2.WaitForStop();

        
                UpdateObjectPicture(0, null);
                UpdateObjectPicture(1, null);
          

            if (trackingThread != null)
            {
                // signal tracking thread to stop
                x1 = y1 = x2 = y2 = -1;
                camera1Acquired.Set();
                camera2Acquired.Set();

                trackingThread.Join();
            }
        }
                    
        //// Object filter properties are updated
        private void tuneObjectFilterForm_OnFilterUpdate(object sender, EventArgs eventArgs)
        {
            colorFilter.Red = RedRange;
            colorFilter.Green = GreenRange;
            colorFilter.Blue = BlueRange;

           
        }

        // Turn on/off object detection
        private void objectDetectionCheck_CheckedChanged(object sender, EventArgs e)
        {
            if ((!objectDetectionCheck.Checked))
            {
                UpdateObjectPicture(0, null);
                UpdateObjectPicture(1, null);
            }
        }

        // received frame from the 1st camera
        private void videoSourcePlayer1_NewFrame(object sender, ref Bitmap image)
        {
            if (objectDetectionCheck.Checked)
            {
                Bitmap objectImage = colorFilter.Apply(image);

                // lock image for further processing
                BitmapData objectData = objectImage.LockBits(new Rectangle(0, 0, image.Width, image.Height),
                    ImageLockMode.ReadOnly, image.PixelFormat);

                // grayscaling
                UnmanagedImage grayImage = grayFilter.Apply(new UnmanagedImage(objectData));

                // unlock image
                objectImage.UnlockBits(objectData);

                // locate blobs 
                blobCounter1.ProcessImage(grayImage);
                Rectangle[] rects = blobCounter1.GetObjectsRectangles();

                if (rects.Length > 0)
                {
                    Rectangle objectRect = rects[0];

                    // draw rectangle around derected object
                    Graphics g = Graphics.FromImage(image);

                    using (Pen pen = new Pen(Color.FromArgb(160, 255, 160), 3))
                    {
                        g.DrawRectangle(pen, objectRect);
                    }

                    g.Dispose();

                    // get object's center coordinates relative to image center
                    lock (this)
                    {
                        x1 = (objectRect.Left + objectRect.Right - objectImage.Width) / 2;
                        y1 = (objectImage.Height - (objectRect.Top + objectRect.Bottom)) / 2;
                        // map to [-1, 1] range
                        x1 /= (objectImage.Width / 2);
                        y1 /= (objectImage.Height / 2);

                        camera1Acquired.Set();
                    }
                }

                    UpdateObjectPicture(0, objectImage);
            }
        }

        // received frame from the 2nd camera
        private void videoSourcePlayer2_NewFrame(object sender, ref Bitmap image)
        {
            if (objectDetectionCheck.Checked)
            {
                Bitmap objectImage = colorFilter.Apply(image);

                // lock image for further processing
                BitmapData objectData = objectImage.LockBits(new Rectangle(0, 0, image.Width, image.Height),
                    ImageLockMode.ReadOnly, image.PixelFormat);

                // grayscaling
                UnmanagedImage grayImage = grayFilter.Apply(new UnmanagedImage(objectData));

                // unlock image
                objectImage.UnlockBits(objectData);

                // locate blobs 
                blobCounter2.ProcessImage(grayImage);
                Rectangle[] rects = blobCounter2.GetObjectsRectangles();

                if (rects.Length > 0)
                {
                    Rectangle objectRect = rects[0];

                    // draw rectangle around derected object
                    Graphics g = Graphics.FromImage(image);

                    using (Pen pen = new Pen(Color.FromArgb(160, 255, 160), 3))
                    {
                        g.DrawRectangle(pen, objectRect);
                    }

                    g.Dispose();

                    // get object's center coordinates relative to image center
                    lock (this)
                    {
                        x2 = (objectRect.Left + objectRect.Right - objectImage.Width) / 2;
                        y2 = (objectImage.Height - (objectRect.Top + objectRect.Bottom)) / 2;
                        // map to [-1, 1] range
                        x2 /= (objectImage.Width / 2);
                        y2 /= (objectImage.Height / 2);

                        camera2Acquired.Set();
                    }
                }

               UpdateObjectPicture(1, objectImage);
            }
        }

        // Thread to track object
        private void TrackingThread()
        {
            float targetX = 0;
            float targetY = 0;

            while (true)
            {
                camera1Acquired.WaitOne();
                camera2Acquired.WaitOne();

                lock (this)
                {
                    // stop the thread if it was signaled
                    if ((x1 == -1) && (y1 == -1) && (x2 == -1) && (y2 == -1))
                    {
                        break;
                    }

                    // get middle point
                    targetX = (x1 + x2) / 2;
                    targetY = (y1 + y2) / 2;
                }

                if (moveCamerasForm != null)
                {
                    // run motors for the specified amount of degrees
                    moveCamerasForm.RunMotors(2 * targetX, -2 * targetY);
                }
            }
        }

       

        // Update object's picture
        public void UpdateObjectPicture(int objectNumber, Bitmap picture)
        {
            System.Drawing.Image oldPicture = null;

            switch (objectNumber)
            {
                case 0:
                    oldPicture = pictureBox1.Image;
                    pictureBox1.Image = picture;
                    break;
                case 1:
                    oldPicture = pictureBox2.Image;
                    pictureBox2.Image = picture;
                    break;
            }

            if (oldPicture != null)
            {
                oldPicture.Dispose();
            }
        }
        // Red range
        public IntRange RedRange
        {
            get { return redRange; }
            set
            {
                redRange = value;
                redSlider.Min = value.Min;
                redSlider.Max = value.Max;
            }
        }
        // Green range
        public IntRange GreenRange
        {
            get { return greenRange; }
            set
            {
                greenRange = value;
                greenSlider.Min = value.Min;
                greenSlider.Max = value.Max;
            }
        }
        // Blue range
        public IntRange BlueRange
        {
            get { return blueRange; }
            set
            {
                blueRange = value;
                blueSlider.Min = value.Min;
                blueSlider.Max = value.Max;
            }
        }

        // Red range was changed
        private void redSlider_ValuesChanged(object sender, EventArgs e)
        {
            redRange.Min = redSlider.Min;
            redRange.Max = redSlider.Max;

            if (OnFilterUpdate != null)
                OnFilterUpdate(this, null);
        }


        // Green range was changed
        private void greenSlider_ValuesChanged(object sender, EventArgs e)
        {
            greenRange.Min = greenSlider.Min;
            greenRange.Max = greenSlider.Max;

            if (OnFilterUpdate != null)
                OnFilterUpdate(this, null);
        }

        // Blue range was changed
        private void blueSlider_ValuesChanged(object sender, EventArgs e)
        {
            blueRange.Min = blueSlider.Min;
            blueRange.Max = blueSlider.Max;

            if (OnFilterUpdate != null)
                OnFilterUpdate(this, null);
        }

        #endregion

        #region(ifKit)

        //IfKit attach event handler
        //Here we'll display the interface kit details as well as determine how many output and input
        //fields to display as well as determine the range of values for input sensitivity slider
        void ifKit_Attach(object sender, AttachEventArgs e)
        {
            InterfaceKit ifKit = (InterfaceKit)sender;

        }

        //Ifkit detach event handler
        //Here we display the attached status, which will be false as the device is disconnected. 
        //We will also clear the display fields and hide the inputs and outputs.
        void ifKit_Detach(object sender, DetachEventArgs e)
        {
            InterfaceKit ifKit = (InterfaceKit)sender;

        }



        //Digital input change event handler
        //Here we check or uncheck the corresponding input checkbox based 
        //on the index of the digital input that generated the event
        void ifKit_InputChange(object sender, InputChangeEventArgs e)
        {
            try
            {
                if (e.Index == 0)
                {
                    tbSensorPressed.Text = "0";
                    // stop();
                }
                else if (e.Index == 1)
                {
                    tbSensorPressed.Text = "1";
                    // stop();
                }
                else if (e.Index == 2)
                {
                    tbSensorPressed.Text = "2";
                    // stop();
                }
                else if (e.Index == 3)
                {
                    tbSensorPressed.Text = "3";
                    // stop();
                }
                else if (e.Index == 4)
                {
                    tbSensorPressed.Text = "";
                    // stop();
                }

                if (e.Value == false)
                {
                    tbSensorPressed.Text = "";
                };
            }
            catch { }
        }

        //Digital output change event handler
        //Here we check or uncheck the corresponding output checkbox
        //based on the index of the output that generated the event
        void ifKit_OutputChange(object sender, OutputChangeEventArgs e)
        {

        }

        //Sensor input change event handler
        //Set the textbox content based on the input index that is communicating
        //with the interface kit
        void ifKit_SensorChange(object sender, SensorChangeEventArgs e)
        {

        }

        //Modify the digital ouputs
        //From the properties window in the form designer, each of the CheckedChanged events for output 
        //checkboxes point to this event handler. The "tag" property for each check box stores user defined 
        //data associated with the control and has been used here to relate the box with an output index.
        private void CheckedChanged(object sender, EventArgs e)
        {
            CheckBox outputChk = (CheckBox)sender;

            int outputIndex = int.Parse((string)outputChk.Tag);

            ifKit.outputs[outputIndex] = outputChk.Checked;
        }

        //Modify the sensitivity of the analog inputs. In other words, the amount that the inputs
        //must change before triggering sensorchange events.
        private void inputTrk_Scroll(object sender, EventArgs e)
        {

        }

        private void ratioChk_CheckedChanged(object sender, EventArgs e)
        {

        }





        //Parses command line arguments and calls the appropriate open
        #region Command line open functions
        private void openCmdLine(Phidget p)
        {
            openCmdLine(p, null);
        }
        private void openCmdLine(Phidget p, String pass)
        {
            int serial = -1;
            int port = 5001;
            String host = null;
            bool remote = false, remoteIP = false;
            string[] args = Environment.GetCommandLineArgs();
            String appName = args[0];

            try
            { //Parse the flags
                for (int i = 1; i < args.Length; i++)
                {
                    if (args[i].StartsWith("-"))
                        switch (args[i].Remove(0, 1).ToLower())
                        {
                            case "n":
                                serial = int.Parse(args[++i]);
                                break;
                            case "r":
                                remote = true;
                                break;
                            case "s":
                                remote = true;
                                host = args[++i];
                                break;
                            case "p":
                                pass = args[++i];
                                break;
                            case "i":
                                remoteIP = true;
                                host = args[++i];
                                if (host.Contains(":"))
                                {
                                    port = int.Parse(host.Split(':')[1]);
                                    host = host.Split(':')[0];
                                }
                                break;
                            default:
                                goto usage;
                        }
                    else
                        goto usage;
                }

                if (remoteIP)
                    p.open(serial, host, port, pass);
                else if (remote)
                    p.open(serial, host, pass);
                else
                    p.open(serial);
                return; //success
            }
            catch { }
        usage:
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("Invalid Command line arguments." + Environment.NewLine);
            sb.AppendLine("Usage: " + appName + " [Flags...]");
            sb.AppendLine("Flags:\t-n   serialNumber\tSerial Number, omit for any serial");
            sb.AppendLine("\t-r\t\tOpen remotely");
            sb.AppendLine("\t-s   serverID\tServer ID, omit for any server");
            sb.AppendLine("\t-i   ipAddress:port\tIp Address and Port. Port is optional, defaults to 5001");
            sb.AppendLine("\t-p   password\tPassword, omit for no password" + Environment.NewLine);
            sb.AppendLine("Examples: ");
            sb.AppendLine(appName + " -n 50098");
            sb.AppendLine(appName + " -r");
            sb.AppendLine(appName + " -s myphidgetserver");
            sb.AppendLine(appName + " -n 45670 -i 127.0.0.1:5001 -p paswrd");
            MessageBox.Show(sb.ToString(), "Argument Error", MessageBoxButtons.OK, MessageBoxIcon.Error);

            Application.Exit();
        }
        #endregion
        #endregion(ifKit)

        #region(stepper)

        //Stepper attach event handler...populate the available fields and controls
        void stepper_Attach(object sender, AttachEventArgs e)
        {
            Stepper attachedStepper = (Stepper)sender;

        }

        //Stepper Detach event handler...Clear all the fields and disable all the controls
        void stepper_Detach(object sender, DetachEventArgs e)
        {
            Stepper detachedStepper = (Stepper)sender;

        }



        //Stepper Current change event handler...Display the current data from the current change event
        void stepper_CurrentChange(object sender, CurrentChangeEventArgs e)
        {

        }

        /*You will need a speed of (2x200)/120 steps /sec = 3,33
        Then, 3/4 rev is 150 steps, so you just have to increment the TargetPosition by 150 before engaging the stepper.*/

        //Stepper position change event handler...Display the position data from the position change event
        void stepper_PositionChange(object sender, StepperPositionChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0: tbLposition.Text = e.Position.ToString();
                    break;
                case 1: tbRposition.Text = e.Position.ToString();
                    break;
            }
        }

        //Stepper Velocity Change event handler...Display the data from the velocity change event
        void stepper_VelocityChange(object sender, VelocityChangeEventArgs e)
        {
            switch (e.Index)
            {
                case 0: tbLvelocity.Text = e.Velocity.ToString();
                    break;
                case 1: tbRvelocity.Text = e.Velocity.ToString();
                    break;
            }  //tbLvelocityTxt.Text = e.Velocity.ToString();
        }

        //Stepper Input Change event handler...Display the data from the Input change event
        void stepper_InputChange(object sender, InputChangeEventArgs e)
        {

        }


        #endregion(stepper)

        #region(servo)

       
        // Phidgets device is attached
        private void servo_Attach(object sender, AttachEventArgs e)
        {
            servo.servos[0].Engaged = false;
            servo.servos[1].Engaged = false;

           // System.Diagnostics.Debug.WriteLine(servo.servos[0].VelocityMin);

            servo.servos[0].VelocityLimit = 50;
            servo.servos[1].VelocityLimit = 50;

            servo.servos[0].Acceleration = servo.servos[0].AccelerationMin;
            servo.servos[1].Acceleration = servo.servos[1].AccelerationMin;

           
            EnableControls(true);
        }

        //Servo position change event handling code
        void servo_PositionChange(object sender, PositionChangeEventArgs e)
        {
          // Servo attached = (Servo)sender;
           
        }
        // Phidgets device is detached
        private void servo_Detach(object sender, DetachEventArgs e)
        {
            

            EnableControls(false);
        }

        // Enable/disable servo controls
        private void EnableControls(bool enable)
        {
            //minServo0.Enabled = enable;
            //maxServo0.Enabled = enable;
            //minServo1.Enabled = enable;
            //maxServo1.Enabled = enable;
        }
        #endregion

        #region(current work)
        #region(servo)

        private void btnLeftEyeUp_Click(object sender, EventArgs e)
        {
            try
            {
                servo.servos[1].Position = 200;
                servo.servos[1].Acceleration = 20;
                servo.servos[1].Engaged = true;
                //threadRE = new Thread(new ThreadStart(RightEyeUp)); //TestThread
                //threadRE.IsBackground = true;
                //threadRE.Start();
            }
            catch (Exception f)
            {
                textBox1.Text = f.Message;
            }

        }

        private void btnLeftEyeCentre_Click(object sender, EventArgs e)
        {
            try
            {
                servo.servos[0].Position = 125;
                servo.servos[0].Acceleration = 20;
                servo.servos[0].Engaged = true;

                servo.servos[1].Position = 125;
                servo.servos[1].Acceleration = 20;
                servo.servos[1].Engaged = true;
                //threadRE = new Thread(new ThreadStart(RightEyeDown)); //TestThread
                //threadRE.IsBackground = true;
                //threadRE.Start();
            }
            catch (Exception f)
            {
                textBox1.Text = f.Message;
            }
        }

        private void btnLeftEyeDown_Click(object sender, EventArgs e)
        {
            try
            {
                //servo.servos[0].Position = 100;
                //servo.servos[0].Acceleration = 20;
                //servo.servos[0].Engaged = true;

                servo.servos[1].Position = 50;
                servo.servos[1].Acceleration = 20;
                servo.servos[1].Engaged = true;
                //threadRE = new Thread(new ThreadStart(RightEyeDown)); //TestThread
                //threadRE.IsBackground = true;
                //threadRE.Start();
            }
            catch (Exception f)
            {
                textBox1.Text = f.Message;
            }
        }

        private void btnLeftEyeLeft_Click(object sender, EventArgs e)
        {
            servo.servos[0].Position = 50;
            servo.servos[0].Acceleration = 20;
            servo.servos[0].Engaged = true;
        }

        private void btnLeftEyeRight_Click(object sender, EventArgs e)
        {
            servo.servos[0].Position = 100;
            servo.servos[0].Acceleration = 20;
            servo.servos[0].Engaged = true;
        }

        private void btnRightEyeLeft_Click(object sender, EventArgs e)
        {
            servo.servos[2].Position = 50;
            servo.servos[2].Acceleration = 20;
            servo.servos[2].Engaged = true;
        }

        private void btnRightEyeRight_Click(object sender, EventArgs e)
        {
            servo.servos[2].Position = 200;
            servo.servos[2].Acceleration = 20;
            servo.servos[2].Engaged = true;
        }
        private void btnRightEyeUp_Click(object sender, EventArgs e)
        {
            servo.servos[3].Position = 200;
            servo.servos[3].Acceleration = 20;
            servo.servos[3].Engaged = true;
         }

        private void btnRightEyeCentre_Click(object sender, EventArgs e)
        {
            servo.servos[2].Position = 125;
            servo.servos[2].Acceleration = 20;
            servo.servos[2].Engaged = true; 

            servo.servos[3].Position = 125;
            servo.servos[3].Acceleration = 20;
            servo.servos[3].Engaged = true;
        }

        private void btnRightEyeDown_Click(object sender, EventArgs e)
        {
            servo.servos[3].Position = 50;
            servo.servos[3].Acceleration = 20;
            servo.servos[3].Engaged = true;
         }


        private void RightEyeUp()
        {
            try
            {
                servo.servos[2].Position = 200;
                servo.servos[2].Acceleration = 20;
                servo.servos[2].Engaged = true;
                while (!servo.servos[2].Stopped)
                    Thread.Sleep(10);

                servo.servos[2].Engaged = false;
            }
            catch { }
        }

        private void RightEyeDown()
        {
            servo.servos[2].Position = 100;
            servo.servos[2].Acceleration = 20;
            servo.servos[2].Engaged = true;
            while (!servo.servos[2].Stopped)
                Thread.Sleep(10);

            servo.servos[2].Engaged = false;
        }

        #endregion(servo)

        #region(sensor)

        private void btnSensors_Click_1(object sender, EventArgs e)
        {
            sensor0();
            sensor1();
            sensor2();
            sensor3();
        }

        //get distance reading from ultrasonic sensor 0
        private void sensor0()
        {
            double distance;
            ifKit.outputs[0] = true;
            distance = (ifKit.sensors[0].Value) * 1.296;
            ifKit.outputs[0] = false;
            tbSensor0.Text = distance.ToString() + "cm";

        }
        private void sensor1()
        {
            double distance;
            ifKit.outputs[1] = true;
            distance = (ifKit.sensors[1].Value) * 1.296;
            ifKit.outputs[1] = false;
            tbSensor1.Text = distance.ToString() + "cm";
        }
        private void sensor2()
        {
            double distance;
            ifKit.outputs[2] = true;
            distance = (ifKit.sensors[2].Value) * 1.296;
            ifKit.outputs[2] = false;
            tbSensor2.Text = distance.ToString() + "cm";
        }
        private void sensor3()
        {
            double distance;
            ifKit.outputs[3] = true;
            distance = (ifKit.sensors[3].Value) * 1.296;
            ifKit.outputs[3] = false;
            tbSensor3.Text = distance.ToString() + "cm";
        }

        #endregion(sensor)

     

      
        //private void btnHome_Click(object sender, EventArgs e)
        //{
        //    LeftAccelertion = 100;
        //    LeftPosition = +150;
        //    RightAccelertion = 100;
        //    RightPosition = -150;


        //    threadLW = new Thread(new ThreadStart(LeftStepperHome)); //TestThread
        //    threadLW.IsBackground = true;
        //    threadLW.Start();

        //    threadRW = new Thread(new ThreadStart(RightStepperHome)); //TestThread
        //    threadRW.IsBackground = true;
        //    threadRW.Start();

        //}

        //private void btnStop_Click(object sender, EventArgs e)
        //{
        //    stop();
        //}

        //private void btnForward_Click(object sender, EventArgs e)
        //{
        //    LeftAccelertion = 100;
        //    LeftPosition = +150;
        //    RightAccelertion = 100;
        //    RightPosition = -150;

        //    threadLW = new Thread(new ThreadStart(LeftForwardOneRev)); //TestThread
        //    threadLW.IsBackground = true;
        //    threadLW.Start();

        //    threadRW = new Thread(new ThreadStart(RightForwardOneRev)); //TestThread
        //    threadRW.IsBackground = true;
        //    threadRW.Start();
        //}

        //private void btnBack_Click(object sender, EventArgs e)
        //{
        //    LeftAccelertion = 100;
        //    LeftPosition = +150;
        //    RightAccelertion = 100;
        //    RightPosition = -150;

        //    threadLW = new Thread(new ThreadStart(LeftBackOneRev)); //TestThread
        //    threadLW.IsBackground = true;
        //    threadLW.Start();

        //    threadRW = new Thread(new ThreadStart(RightBackOneRev)); //TestThread
        //    threadRW.IsBackground = true;
        //    threadRW.Start();
        //}

       
        #endregion(current work)

        #region(closing)

        // Main form closing - stop cameras
        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            StopCameras();
        }

       

        private void btnShutDown_Click(object sender, EventArgs e)
        {
            ShutDownComputer();
        }


        //Shutdown computer
        public static void ShutDownComputer()
        {
            ManagementBaseObject outParameters = null;
            ManagementClass sysOS = new ManagementClass("Win32_OperatingSystem");
            sysOS.Get();
            // enables required security privilege.
            sysOS.Scope.Options.EnablePrivileges = true;
            // get our in parameters
            ManagementBaseObject inParameters = sysOS.GetMethodParameters("Win32Shutdown");
            // pass the flag of 0 = System Shutdown
            inParameters["Flags"] = "1";
            inParameters["Reserved"] = "0";
            foreach (ManagementObject manObj in sysOS.GetInstances())
            {
                outParameters = manObj.InvokeMethod("Win32Shutdown", inParameters, null);
            }
        }

        private void btnExitApp_Click(object sender, EventArgs e)
        {
            disengage();
            ApplicationExit();
        }



        //exitapplication
        public static void ApplicationExit()
        {
            Application.Exit();
        }

        private void moveCameraButton_Click(object sender, EventArgs e)
        {
            if (moveCamerasForm == null)
            {
                moveCamerasForm = new MoveCamerasForm();
            }

            moveCamerasForm.Show();
        }

        private void disengage()
        {
             for (int i = 0; i < 4; i++)
            {

                servo.servos[i].Engaged = false;
              //  stepper.steppers[i].Engaged = false;
             }
        }

        #endregion(closing)



        //Sensor Change event handler...Display the sensor index and it's new value to the console
        static void ifKit1_SensorChange(object sender, SensorChangeEventArgs e)
        {
            //Console.WriteLine("Sensor {0} {1}", e.Index, e.Value.ToString());
        }

        //Input Change event handler...Display the input index and the new value to the console
        static void ifKit1_InputChange(object sender, InputChangeEventArgs e)
        {

            // Console.WriteLine("i/p 3 {0} {1}", e.Index, e.Value.ToString());
            if (ifKit1.SerialNumber == 117172)
            {
                if (e.Index == 0)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[0] = true;

                        eyes_and_wheels.servos[6].Engaged = true; //wheelLeft
                        eyes_and_wheels.servos[7].Engaged = true; //wheelRight
                    }
                    else
                    {
                        ifKit1.outputs[0] = false;
                    }

                if (e.Index == 1)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[1] = true;
                        eyes_and_wheels.servos[6].Engaged = false;
                        eyes_and_wheels.servos[7].Engaged = false;
                    }
                    else
                    {
                        ifKit1.outputs[1] = false;
                    }

                if (e.Index == 2)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[2] = true;


                        right_arm.servos[0].Position = 50;
                        right_arm.servos[0].VelocityLimit = 100;
                        right_arm.servos[0].Engaged = true;
                        right_arm.servos[1].Position = 50;
                        right_arm.servos[1].VelocityLimit = 100;
                        right_arm.servos[1].Engaged = true;

                        eyes_and_wheels.servos[1].Position = 96;
                        eyes_and_wheels.servos[1].VelocityLimit = 49;
                        eyes_and_wheels.servos[1].Engaged = true;
                        eyes_and_wheels.servos[0].Position = 50;
                        eyes_and_wheels.servos[0].Engaged = true;
                    }
                    else
                    {
                        ifKit1.outputs[2] = false;
                        eyes_and_wheels.servos[1].Engaged = false;
                        eyes_and_wheels.servos[0].Engaged = false;
                    }

                if (e.Index == 3)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[3] = true;


                        right_arm.servos[0].Position = 200;
                        right_arm.servos[0].Engaged = true;
                        right_arm.servos[1].Position = 200;
                        right_arm.servos[1].Engaged = true;

                        eyes_and_wheels.servos[1].Position = 200;
                        eyes_and_wheels.servos[1].Engaged = true;
                        eyes_and_wheels.servos[0].Position = 200;
                        eyes_and_wheels.servos[0].Engaged = true;
                    }
                    else
                    {
                        ifKit1.outputs[3] = false;
                        eyes_and_wheels.servos[1].Engaged = false;
                        eyes_and_wheels.servos[0].Engaged = false;
                    }

                if (e.Index == 4)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[4] = true;
                    }
                    else
                    {
                        ifKit1.outputs[4] = false;
                    }

                if (e.Index == 5)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[5] = true;
                    }
                    else
                    {
                        ifKit1.outputs[5] = false;
                    }

                if (e.Index == 6)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[6] = true;
                    }
                    else
                    {
                        ifKit1.outputs[6] = false;
                    }

                if (e.Index == 7)

                    if (e.Value == true)
                    {
                        ifKit1.outputs[7] = true;
                    }
                    else
                    {
                        ifKit1.outputs[7] = false;
                    }
            }
        }


        //Output change event handler...Display the output index and the new valu to the console
        static void ifKit1_OutputChange(object sender, OutputChangeEventArgs e)
        {

        }

        //ifkit2
        //Sensor Change event handler...Display the sensor index and it's new value to the console
        static void ifKit2_SensorChange(object sender, SensorChangeEventArgs e)
        {
            // Console.WriteLine("Sensor {0} {1}", e.Index, e.Value.ToString());
        }

        //Input Change event handler...Display the input index and the new value to the console
        static void ifKit2_InputChange(object sender, InputChangeEventArgs e)
        {


        }


        //Output change event handler...Display the output index and the new valu to the console
        static void ifKit2_OutputChange(object sender, OutputChangeEventArgs e)
        {

        }

        //ifkit3
        //Sensor Change event handler...Display the sensor index and it's new value to the console
        static void ifKit3_SensorChange(object sender, SensorChangeEventArgs e)
        {
            Console.WriteLine("Sensor {0} {1}", e.Index, e.Value.ToString());
        }

        //Input Change event handler...Display the input index and the new value to the console
        static void ifKit3_InputChange(object sender, InputChangeEventArgs e)
        {
            Console.WriteLine("i/p Sensor {0} {1}", e.Index, e.Value.ToString());

        }


        //Output change event handler...Display the output index and the new valu to the console
        static void ifKit3_OutputChange(object sender, OutputChangeEventArgs e)
        {

        }
        //Position CHange event handler...display which motor changed position and its new position value to the console
        static void advServo_PositionChange(object sender, PositionChangeEventArgs e)
        {
            //eyes_and_wheels.servos[1].VelocityLimit = 1;
            // if (eyes_and_wheels.servos[0].Position >= 150)
            // SystemSounds.Beep.Play();

            //Console.WriteLine("Motor #{0} - Actual Position: {1}",e.Index, e.Position.ToString());
        }

        //Velocity CHange event handler....display which motor's velocity is changing and show its new value to the console
        static void advServo_VelocityChange(object sender, VelocityChangeEventArgs e)
        {
            //Console.WriteLine("Motor #{0} - Actual Velocity: {1}", e.Index,e.Velocity.ToString());
        }

        //Acceleration change event handler...Display which axis the device is accelerating in as well as the measured acceleration value
        static void accel_AccelerationChange(object sender, AccelerationChangeEventArgs e)
        {
           // Console.WriteLine("Axes {0} Acceleration {1}", e.Index, e.Acceleration);
           
            //switch (e.Index)
            //{
            //    case 0: tbAccel0.Text = e.Acceleration.ToString();
            //        break;
            //    case 1: tbRposition.Text = e.Position.ToString();
            //        break;
            //}
        }

        //Input Change event handler...DIsplay the new value of te digital input (the pushbutton) to the console
        static void encoder_InputChange(object sender, InputChangeEventArgs e)
        {
            Console.WriteLine("Input {0} value {1}", e.Index, e.Value);
        }

        //Position change event handler...Display the index of the encoder that change, the position change value, the time between changes, and the current encoder position value to the console
        static void encoder_PositionChange(object sender, EncoderPositionChangeEventArgs e)
        {
            Console.WriteLine("Encoder {0} Change {1} Time {2} Position {3}", e.Index, e.PositionChange, e.Time, encoder.encoders[e.Index]);
        }

        //Attach event handler...Display the serial number of the attached 
        //accelerometer to the console
        static void accel_Attach(object sender, AttachEventArgs e)
        {


            Accelerometer attached = (Accelerometer)sender;


            try
            {
                attached.axes[0].Sensitivity = 0.19;
                attached.axes[1].Sensitivity = 0.19;
                if (attached.axes.Count == 3)
                    attached.axes[2].Sensitivity = 0.19;



            }
            catch (PhidgetException ex)
            {
                MessageBox.Show(ex.Description);
            }
        }



        #region(Errors)

        //Error event handler...Display the error description to the console
        static void ifKit_Error(object sender, ErrorEventArgs e)
        {
            Console.WriteLine("ifKit Error ", e.Description);
        }

        //Error event handler....Display the error description to the console
        static void advServo_Error(object sender, ErrorEventArgs e)
        {
            Console.WriteLine("AdvancedServo Error: {0}", e.Description);
        }

        //Error event handler...Display the description of the error to the console
        static void accel_Error(object sender, ErrorEventArgs e)
        {
            Console.WriteLine("Accelerometer Error ", e.Description);
        }
        //Error event handler...Display the error description to the console
        static void encoder_Error(object sender, ErrorEventArgs e)
        {
            Console.WriteLine("Encoder Errror ", e.Description);
        }

        #endregion(Errors)






    }
}