using System;
using System.Xml;


public class ObjectsXmlParser
{
    public XmlDocument xDoc;
    public XmlDocument xX;
    public XmlDocument xY;
    public XmlDocument xType;

   public void initialize()
    {
        xDoc = new XmlDocument() ;
       xX = new XmlDocument() ;
       xY = new XmlDocument() ;
       xType = new XmlDocument();
    }

    public void LoadDoc(string path)
    {
        initialize();
        xDoc.LoadXml(path);
        xX.LoadXml(path);
        xY.LoadXml (path);
        xType.LoadXml(path);
    }

    public void GetItems(string searchKey)
    {
        xDoc.GetElementsByTagName(searchKey);
        xX.GetElementsByTagName("x");
        xY.GetElementsByTagName("y");
        xType.GetElementsByTagName("type");
    }
}

public class DialogXmlParser
{
    public XmlDocument xTalk;

    void initialize()
    {
        xTalk = new XmlDocument();
    }

    public void LoadDoc(string path)
    {
        initialize();
        xTalk.LoadXml(path);
    }

    public void GetItems(string speaker)
    {
        xTalk.GetElementsByTagName(speaker);
    }

    public void GetItems()
    {
        xTalk.GetElementsByTagName("*");
    }
}

public class MAPSizeXml
{
    XmlDocument xMap;

    void initialize()
    {
        xMap = new XmlDocument();
    }

    public void LoadDoc(string path)
    {
        initialize();
        xMap.LoadXml(path);
    }

    public void GetItems()
    {
        xMap.GetElementsByTagName("*");
    }

}

public class GeneralXmlParser
{
    XmlDocument xDoc;

    void initialize()
    {
        xDoc = new XmlDocument() ;
    }

    public void LoadDoc(string path)
    {
        initialize();
        xDoc.LoadXml(path);
    }

    public void GetItems(string tag)
    {
        xDoc.GetElementsByTagName(tag);
    }

}
        


