using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;
using SeeSharp.Xna.Video;
using DirectShowLib;


namespace Nameless
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        /*Disclaimer: the variables in this game are not intended to refer to adult content*/
        GraphicsDeviceManager graphics;
         SpriteBatch spriteBatch;
        Texture2D title;
        Texture2D map;
       Rectangle titler;        
        Rectangle Camera; //Since the map has a fixed size and cannot be too big in size, I'll use this rectangle to draw a portion of the map
        Rectangle vr; //Rectangle used for displaying the movie
        
        int GamePos=0;//Tracks Game level (o= title screen, 1= New, -1 = Load, 1+ = levels (e.g. level1 = 2))
        int MovPos= 0;//Tracks Movie to play (0= beginning movie)
        int SaveSlot=1;//Used to choose the SaveSlot
        int ScreenXm;//ScreenXm = right bound of screen (m = max)
        int ScreenYm;//ScreenYm = bottom bound of screen (m = max)
        int qlist = 0;//number of questions answered
        int addChar =0;//Times keyboard presses so letters are not inputed more than once when user meant once
        int Level = 1; //Character level
        int HP= 200;
        int Energy = 100;
        int EXP = 0;
        int MAP = 1;
        int oldX = 0;//Used in order to make the Camera move with the hero
        int oldY = 0;//Same as above
        KeyboardState kb;//keyboard
        KeyboardState kbdown;
        Keys press;//Used normally for tracking key presses to enter into strings.
        
        bool ED = false; //Flag that indicates whether enter was pressed down before
        bool MAPp =false;// Flag to be used in order to know if a map has already started
        bool VidP = false; //Flag for tracking whether a video is playing.
        bool pause = false;//Flag for pause
        SpriteFont SubTitlef;
        SpriteFont Chatf;
        SpriteFont Titlef;
        SpriteFont Statf;
        SpriteFont Statf2;//I was not sure if to use 1 font for all the statuses so I created another spritefont object. Modify as you see fit.
        Vector2[] Texts = new Vector2 [10];//Created an array of vector with enough objects to satisfy current needs
        String.Strings Q = new String.Strings ();
        String.Strings Ans = new String.Strings ();//answers from users
        FileSystem FileManagement = new FileSystem();
        string c;
        string d = "New Character";
        string CharName = "";
        VideoPlayer MOV;// Movie class for loading movies and playing them.
        
        
        //XML Parsers. Actually my classes for loading the three xml files accompanying the map.
        ObjectsXmlParser objects;
        DialogXmlParser dialog;
        MAPSizeXml MapSize;
        GeneralXmlParser GeneralXmlPParser;
 
        //Char objects
          hero hero = new hero() ;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
#if DEBUG
            graphics.PreferredBackBufferWidth = 800;
            graphics.PreferredBackBufferHeight = 600;
            graphics.IsFullScreen = false;

#else
            graphics.PreferredBackBufferWidth = GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Width;
            graphics.PreferredBackBufferHeight = GraphicsAdapter.DefaultAdapter.CurrentDisplayMode.Height;
            graphics.IsFullScreen = true;
#endif
            Content.RootDirectory = "Content";
            
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            
            base.Initialize();
            //MOV = new VideoPlayer("Intro.wmv", GraphicsDevice);
           // MOV.Stop();
            ScreenXm = graphics.GraphicsDevice.Viewport.Width;
            ScreenYm = graphics.GraphicsDevice.Viewport.Height;
          //graphics.ToggleFullScreen();
            //this.Window.AllowUserResizing = true;//Caution: I tested this line but the game would get distorted if at least the background is updated when the window is updated.
            /*The code above allows to start in full screen
             * like a real game should. The code below is to set the main holder of the hero's
             * graphic at the start location of title screen once.The same goes for the title rectangle 
             *and smoke rectangle*/
            titler = new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height);
            hero.Initialize((graphics.GraphicsDevice.Viewport.Height / 2) - 50, (graphics.GraphicsDevice.Viewport.Width / 2) - 50);
            /*Initializing the fonts to be used in the game.*/
            
            GSQuestions();
            
            //FileManagement.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            title = Content.Load<Texture2D>("maps/Title/backgroundT");
            hero.LoadContent(Content);
           // this.hero.herOup=Content.Load<Texture2D>("Graphics\\char\\FlameAbuser\\fireup");
            //this.hero.herOupl=Content.Load<Texture2D>("Graphics/char/FlameAbuser/fireupl");
            //this.hero.herOupr = Content.Load<Texture2D>("Graphics/char/FlameAbuser/fireupr");
           
            //hero.LoadContent();
            //function broken at the moment

            SubTitlef = Content.Load<SpriteFont>("FontObjs/Bauer");
            Titlef = Content.Load<SpriteFont>("FontObjs/Old English Text MT");
            Chatf = Content.Load<SpriteFont>("FontObjs/Bookman Old Style");
            Statf = Content.Load<SpriteFont>("FontObjs/Atomic Clock Radio");
            Statf2 = Content.Load<SpriteFont>("FontObjs/Arial");
            
            // TODO: use this.Content to load your game content here
            
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
           // MOV.Stop();
           // MOV.Dispose();
                
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();
            kb = Keyboard.GetState();
            //Exit point of game
            if (kb.IsKeyDown(Keys.Escape ))
            {
               this.Exit();
            }
            //DummyDraw();
            if (kb.IsKeyDown(Keys.P))//whenever someone press the P key, the game is put into a loop so it creates the state of pause
            {
                do{
                    if (kb.IsKeyUp (Keys.P ))
                    {
                    PauseGame();
                    }
                }while(pause==true);
            }

            //If game is at title screen
            /* This Block of code will control the animations and sprites in 
             * the loading screen. As you can see this is my first time animating
             *  and thus this looks more like a raw trial. I will create classes 
             * later on to group better the code for the next levels.
             * Hope is legible enough so I won't need to
             * add much comments to this section.*/
            if (GamePos == 0)
            {
                            
               
                if (hero.H_Right() == ScreenXm)
                {
                    GamePos = 1;
                }
                if (hero.H_Left()  == 5)
                {
                    GamePos = -1;
                }
            }
            
            /*This block of code will control save screen behavior*/
            if (GamePos == 1)
            {
                graphics.GraphicsDevice.Clear(Color.White);
                title = Content.Load<Texture2D>("maps/Save/SaveScreen");
                titler = new Rectangle(0, 0, graphics.GraphicsDevice.Viewport.Width, graphics.GraphicsDevice.Viewport.Height);
                Texts[0] = new Vector2(300, 400);
                
                InputKey.Stringinputmanager inp = new InputKey.Stringinputmanager();
                if (addChar == 6)
                {
                    if (d == "New Character")
                    {
                        d = "";
                    }
                    d = d + inp.GetNextChar(kb);
                    addChar = 0;
                }
                else
                {
                    addChar++;
                }
                if (kb.IsKeyDown(Keys.Back))
                {
                    d = "New Character";
                }

                    c = d;
                    Ans.SetVal(c,qlist );
                    if (addChar == 6)
                    {
                        addChar = 0;
                       
                    }
                    else
                    {
                        addChar++;
                    }
                    if (qlist == 1)
                    {
                        if (kb.IsKeyDown(Keys.Up))
                        {
                            if (SaveSlot < 3)
                            {
                                SaveSlot++;
                            }
                        }
                        if (kb.IsKeyDown(Keys.Down))
                        {
                            if (SaveSlot != 0)
                            {
                                SaveSlot--;
                            }
                        }
                    }

                if (kb.IsKeyDown(Keys.Enter))
                {
                    //Making sure the Key Enter has been pressed down and released so that addChar is updated correctly
                    if (ED == false)
                    {
                        kbdown = kb;
                        ED = true;
                    }
                    else
                    {
                        if (ED == true )//&& kbdown.IsKeyDown (Keys.Enter )&& kb.IsKeyUp(Keys.Enter))
                        {
                            qlist++;
                            ED = false;
                        }
                    }
                    //qlist = 1;
                    if (qlist == 2)
                    {
                        
                        /*Below is the code to check if the file Char.txt, which contains the name of the hero, exist*/
                        if (SaveSlot == 0)
                        {
                            /*As you can see the code for saving is really crude and tedious, but that's because 
                             * I ran through some troubel creating the FileManagement class and at the end
                             * I told myself that the game was only going to run in Windows and that the
                             * XBOX port was going to be a fantasy (plus how could I distribute it anyways
                             * without costing me a cent and so that it can be 100% free) so I opt for creating 
                             * a C++ short program for saving the data. Since fc.exe was way faster to create than repairing 
                             * the errors in FileManagement, I just used Process.Start() and all problems solved.
                             * Also, notice that the first part of the parameters for fc.exe repeats at the end. That's
                             * because I messed it up but because fc.exe only uses the first 2 parameters I did not
                             * bother to delete the repetition-- I was feeling like stopping anyways--.*/
                            if (FileManagement.FileExists("SaveData\\Save01\\Char.txt") == false)
                            {
                                FileManagement.CreateDirectory("SaveData", "Save01");
                                //FileManagement.CreateFile("SaveData\\Save01\\Level.txt");
                                //FileManagement.CreateFile("SaveData\\Save01\\Energy.txt");
                                //FileManagement.CreateFile("SaveData\\Save01\\HP.txt");
                                //FileManagement.CreateFile("SaveData\\Save01\\EXP.txt");
                                //System.Diagnostics.Process.Start("utilities\\fc.exe","SaveData\\Save01\\Char.txt");
                                FileManagement.content = "1";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\Level.txt" + " " + FileManagement.content);
                                FileManagement.content = "100";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\Energy.txt" + " " + FileManagement.content);
                                FileManagement.content = "200";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\HP.txt" + " " + FileManagement.content);
                                FileManagement.content = "0";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\EXP.txt" + " " + FileManagement.content);
                                FileManagement.content = Ans.GetVal(0);
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\Char.txt" + " " + FileManagement.content);
                                FileManagement.content = MAP.ToString();
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save01\\MAP.txt");
                                GamePos++;
                            }

                            if (FileManagement.FileExists("SaveData\\Save02\\Char.txt") == false)
                            {
                                FileManagement.CreateDirectory("SaveData", "Save02");
                                //FileManagement.CreateFile("SaveData\\Save02\\Level.txt");
                                //FileManagement.CreateFile("SaveData\\Save02\\Energy.txt");
                                //FileManagement.CreateFile("SaveData\\Save02\\HP.txt");
                                //FileManagement.CreateFile("SaveData\\Save02\\EXP.txt");
                               // FileManagement.CreateFile("SaveData\\Save02\\Char.txt");
                                //FileManagement.content = "1";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\Level.txt" + " " + FileManagement.content);
                                FileManagement.content = "100";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\Energy.txt" + " " + FileManagement.content);
                                FileManagement.content = "200";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\HP.txt" + " " + FileManagement.content);
                                FileManagement.content = "0";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\EXP.txt" + " " + FileManagement.content);
                                FileManagement.content = Ans.GetVal(0);
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\Char.txt" + " " + FileManagement.content);
                                FileManagement.content = MAP.ToString();
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save02\\MAP.txt");
                                GamePos++;
                            }

                            if (FileManagement.FileExists("SaveData\\Save03\\Char.txt") == false)
                            {
                                FileManagement.CreateDirectory("SaveData", "Save03");
                                //FileManagement.CreateFile("SaveData\\Save03\\Level.txt");
                                //FileManagement.CreateFile("SaveData\\Save03\\Energy.txt");
                                //FileManagement.CreateFile("SaveData\\Save03\\HP.txt");
                                //FileManagement.CreateFile("SaveData\\Save03\\EXP.txt");
                                //FileManagement.CreateFile("SaveData\\Save03\\Char.txt");
                                FileManagement.content = "1";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\Level.txt" + " " + FileManagement.content);
                                FileManagement.content = "100";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\Energy.txt" + " " + FileManagement.content);
                                FileManagement.content = "200";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\HP.txt" + " " + FileManagement.content);
                                FileManagement.content = "0";
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\EXP.txt" + " " + FileManagement.content);
                                FileManagement.content = Ans.GetVal(0);
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\Char.txt" + " " + FileManagement.content);
                                FileManagement.content = MAP.ToString();
                                System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save03\\MAP.txt");
                                GamePos++;
                 
                            }

                            if (FileManagement.FileExists("SaveData\\Save03\\Char.txt") == true && FileManagement.FileExists("SaveData\\Save02\\Char.txt") == true && FileManagement.FileExists("SaveData\\Save01\\Char.txt") == true)
                            {
                                d = "Can't randomize save!Please choose a slot from 1-3 to overwrite!";
                            }
                        }
                        else
                        {
                            FileManagement.CreateDirectory("SaveData", "Save0" + SaveSlot.ToString());
                            //FileManagement.CreateFile("SaveData\\Save0" +SaveSlot  + "\\Level.txt");
                            //FileManagement.CreateFile("SaveData\\Save0" +SaveSlot  + "\\Energy.txt");
                            //FileManagement.CreateFile("SaveData\\Save0" +SaveSlot  + "\\HP.txt");
                            //FileManagement.CreateFile("SaveData\\Save0" +SaveSlot  + "\\EXP.txt");
                           // FileManagement.CreateFile("SaveData\\Save0" +SaveSlot  + "\\Char.txt");
                            FileManagement.content = "1";
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\Level.txt" + " " + FileManagement.content);
                            FileManagement.content = "100";
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\Energy.txt" + " " + FileManagement.content);
                            FileManagement.content = "200";
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\HP.txt" + " " + FileManagement.content);
                            FileManagement.content = "0";
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\EXP.txt" + " " + FileManagement.content);
                            FileManagement.content = Ans.GetVal(0);
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\Char.txt" + " " + FileManagement.content);
                            FileManagement.content = MAP.ToString();
                            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0"+SaveSlot +"\\MAP.txt");
                            GamePos++;
                           
                 
                        }
                        //Add aditional code for save file below
                    }
                    else
                    {
                        
                    }
                   }
                 
            }

            //This block of code will control the Loading Screen behavior
            if (GamePos == -1)
            {
                graphics.GraphicsDevice.Clear(Color.White );
                title = Content.Load<Texture2D>("maps/Loading/LoadingScreen");
                if (kb.IsKeyDown(Keys.Up))
                {
                    if (SaveSlot < 3)
                    {
                        SaveSlot++;
                    }
                }
                if (kb.IsKeyDown(Keys.Down))
                {
                    if (SaveSlot != 0)
                    {
                        SaveSlot--;
                    }
                }
                Texts[0] = new Vector2(200, 200);
                if (SaveSlot == 0)
                {
                    SaveSlot = 1;
                }
                if (kb.IsKeyDown(Keys.Enter))
                {
                    LoadGame();
                    GamePos = 2;

                }
            }

            if (GamePos > 1 && MAPp == false)
            {
               if (MAPp == false)
                {
                    BeginLevel();
                    MAPp = true;
                }
                 followCamera();
                //PlayVid("Intro.wmv");
                
            }

            if (GamePos > 1)// Did not noticed the fault of the if...block above 
            {
                followCamera();
            }

            /*Mapping Controls for the hero's movements*/
            if (kb.IsKeyDown(Keys.Right))
            {
                Camera.X += 1;
            }
            if (kb.IsKeyDown(Keys.Left))
            {
                 Camera.X -= 1;
            }
            /*if (kb.IsKeyDown(Keys.Down))
            {
                if (heror.Bottom == titler.Bottom)
                {
                    heror.Bottom = titler.Bottom;
                }
                else
                {
                    heror.Y++;
                }
            }*///not really necessary. found a better way
            
            if (kb.IsKeyDown(Keys.Up)&& (hero.hero_Y() <= Camera.Height /2))
            {
                Camera.Y -= 1;
            }
            
            //Update movement of the hero
            hero.hero_update_pos(kb,Content );

            //Update MOV just in case
            if (VidP == true)
            {
                MOV.Update();
            }
           // AnimateChar();
            hero.Frame_R_Out(Content);
            //End of Jump controls
            /*Begin Playing Levels. Level # is = to GamePos-1. After  each level remeber to call the save() function.
             * Only one difficulty will be applied to this game so far unless someone feels like updating code.
             */
            


            // TODO: Add your update logic here
            

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            graphics.GraphicsDevice.Clear(Color.White);
            spriteBatch.Begin();
            //Draws title screen
            if (GamePos == 0)
           {
                
                spriteBatch.Draw(title,titler, titler,Color.White);
                Texts[0] = new Vector2 (50,25);
                spriteBatch.DrawString(Titlef, "NAMELESS", Texts[0], Color.Yellow);
                Texts[0] = new Vector2(25, 100);
                spriteBatch.DrawString(SubTitlef, "Legend", Texts[0], Color.Violet);
                Texts[0] = new Vector2(graphics .GraphicsDevice .Viewport .Width-100, graphics.GraphicsDevice.Viewport.Height-200);
                spriteBatch.DrawString(Chatf , "NEW==>>>", Texts[0], Color.Red);
                Texts[0] = new Vector2(graphics .GraphicsDevice .Viewport .Width /60, graphics.GraphicsDevice.Viewport.Height - 200);
                spriteBatch.DrawString(Chatf, "<<<==Load", Texts[0], Color.Red);
                hero.Draw(spriteBatch);
                
           }
            //Draws Save/Account Creation Screen
           if (GamePos == 1)
           {
              
               spriteBatch.Draw(title, titler, titler, Color.White);
               if (qlist < 2)
               {
                   spriteBatch.DrawString(Chatf, Q.GetVal(qlist), Texts[0], Color.Blue);
               }
               else
               {
                   spriteBatch.DrawString(Chatf, Q.GetVal(1), Texts[0], Color.Blue);
               }
               Texts[1] = new Vector2(300, 450);
               spriteBatch.DrawString(Chatf, d, Texts[1], Color.YellowGreen );
               if (qlist == 1)
               {
                   spriteBatch.DrawString(Chatf, "SaveSlot" + SaveSlot, Texts[1], Color.YellowGreen);
               }
               hero.Draw(spriteBatch);
             
           }
            //Draws Loading Screen
            if (GamePos == -1)
            {
              
               spriteBatch.Draw(title, titler, titler, Color.White);
               spriteBatch.DrawString(Chatf, Q.GetVal(2), Texts[0], Color.Blue);
               Texts[1] = new Vector2(400, 400);
               spriteBatch.DrawString(Chatf, "LoadSlot" + SaveSlot, Texts[1], Color.YellowGreen);
               hero.Draw(spriteBatch);
               
            }

            //Draw a level
            if (GamePos > 1)
            {
                
                spriteBatch.Draw(map, titler, Camera, Color.White);
                Texts [5]=new Vector2 (200,200);
                spriteBatch.DrawString(Chatf, "heror.x:" + hero.hero_X().ToString(), Texts[5], Color.White);
                hero.Draw(spriteBatch);
              
            }

           
          Texts [0] = new Vector2 (0,0);
            spriteBatch.DrawString(Statf2, "HP:" + " " + HP, Texts[0], Color.Red);
            Texts[0] = new Vector2(75, 0);
            spriteBatch.DrawString(Statf, "Energy:" + Energy, Texts[0], Color.Blue);
            Texts[0] = new Vector2(210, 0);
            spriteBatch.DrawString(Statf2, "Level:" + " " + Level, Texts[0], Color.Yellow);
            hero.Draw(spriteBatch);
          

           if (VidP == true)
           {
               
               spriteBatch.Draw(MOV.OutputFrame, vr, Color.Yellow);
            
           }
          
            //The function below is rather broken so I'm doing a manual drawing
          
            //This is a code snippet to test the state of a texture
         /*  Rectangle r = new Rectangle(0, 0, 100, 100);
           Texture2D t = Content.Load<Texture2D>("Graphics\\char\\FlameAbuser\\Fireb");
           spriteBatch.Begin();
           spriteBatch.Draw(t, r, Color.Yellow);
           spriteBatch.End();*/
            // TODO: Add your drawing code here
           spriteBatch.End();
            base.Draw(gameTime);
        }

        //I'm adding a function to have the game creating screen questions already enumerated
        void GSQuestions()
        {
            Q.SetVal("Please type the name you want for the hero!", 0);
            Q.SetVal("Choose a Save slot. Use the up and down arrows!", 1);
            Q.SetVal("Choose a Load slot. Use the up and down arrows!", 2);
        }

        void SavePoint()//Call this function to save game state. Note: it won't save the position in the map, but it will save the map where the checkpoint was done
        {
            FileManagement.content = Level.ToString();
            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\Level.txt" + " " + FileManagement.content);
            FileManagement.content = Energy.ToString();
            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\Energy.txt" + " " + FileManagement.content);
            FileManagement.content = HP.ToString();
            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\HP.txt" + " " + FileManagement.content);
            FileManagement.content = EXP.ToString();
            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\EXP.txt" + " " + FileManagement.content);
            FileManagement.content = MAP.ToString();
            System.Diagnostics.Process.Start("utilities\\fc.exe", FileManagement.content + " " + "SaveData\\Save0" + SaveSlot + "\\MAP.txt");
        }

        void LoadGame()//Call this funcion in the Loading Screen to set variables needed for beginning the game
        {
            EXP = Convert.ToInt32(System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\EXP.txt"));
            Level = Convert.ToInt32(System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\Level.txt"));
            HP = Convert.ToInt32(System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\HP.txt"));
            Energy = Convert.ToInt32(System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\Energy.txt"));
            MAP = Convert.ToInt32(System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\MAP.txt"));
            CharName = System.IO.File.ReadAllText("SaveData\\Save0" + SaveSlot + "\\Char.txt");
            Ans.SetVal(CharName, 0);
        }

        void BeginLevel()
        {
             //objects.LoadDoc ("maps\\Level"+MAP+"\\objs.xml");
             //dialog.LoadDoc("maps\\Level" + MAP + "\\dialog.xml");
             //MapSize.LoadDoc("maps\\Level" + MAP + "\\MapSize.xml");
            map = Content.Load<Texture2D>("maps\\Level" + MAP + "\\Background");
            Camera = new Rectangle (titler.Left,titler.Bottom,400,300);
           
        }
         


        void followCamera()
        {
            if (kb.IsKeyDown(Keys.Up) && kb.IsKeyDown(Keys.Right))
            {
                Camera.X += 1;
                Camera .Y -= 1;
            }
            if (kb.IsKeyDown(Keys.Up) && kb.IsKeyDown(Keys.Left))
            {
                Camera.X -= 1;
                Camera.Y += 1;
            }
            if (Camera.Left < titler.Left)
            {
                Camera.X = titler.Left;
            }
            if (Camera.Right > titler.Right)
            {
                Camera.X = (titler.Right- Camera.Width);
            }
            if (Camera.Bottom > titler.Bottom)
            {
                Camera.Y = (titler.Bottom-Camera.Height );
            }
            if (Camera.Top < titler.Top)
            {
                Camera.Y = titler.Top;
            }
            if (hero.hero_Y() > (Camera.Height / 2))
            {
                Camera.Y += 1;
            }
            /* The code above is to set special boundaries for the camera so that it does not escape the game world
             * and thus show you the void areas (usually black).
             * */

       }

        void PlayVid(string file)
        {
            if (VidP != true)
            {
                
                MOV = new VideoPlayer(file,GraphicsDevice );
                MOV.OnVideoComplete += new EventHandler(videoPlayer_OnVideoComplete);
                MOV.Play();
                VidP = true;
            }
                if (MOV.CurrentState == VideoState.Playing)
                {
                    vr = new Rectangle (0,0,graphics.GraphicsDevice.Viewport.Width,graphics.GraphicsDevice.Viewport.Height);
                    MOV.Update();
                    }
                if ((MOV.CurrentState == VideoState.Stopped) && (VidP == true))
                {
                    VidP = false;
                    MovPos++;
                    MOV.Dispose();
                }
            }

        void videoPlayer_OnVideoComplete(object sender, EventArgs e)
        {
            // Hide Objects once the video has finished
           VidP = false;
        }
      
        void PickMap()//Use this function to load customized level content (You know the stuff that is unique to that level. Will eventually become a crowded function)
        {
            if (MAP == 1)
            {
                Level1();
            }
        }

        void PauseGame()//This short function has the great job of pausing the game by preventing the rest of the code in Update() from processing
        {
            do//Pausing loop
            {
                kb = Keyboard .GetState ();
                Texts[9] = new Vector2(250, 250);
                spriteBatch.Begin();
                spriteBatch.DrawString(SubTitlef, "Pause", Texts[9], Color.Red);
                spriteBatch.End();
                if (kb.IsKeyDown(Keys.P))
                {
                    pause = false;
                }
                    else
                {
                    pause = true;
                }
               } while (pause==true);
        }

        void DummyDraw()//Draw test
        {
            spriteBatch.Begin();
            spriteBatch.DrawString(SubTitlef, "Pause", Texts[9], Color.White);
            spriteBatch.End();
        }
       

        /*All code below will be exclusive code for the different parts of the story (levels).
         * The problem is that if I create its own class, then I would have to set dummy variables
         * that'll be referencing to the variables in Game1 (the main module). So I'm hard coding
         * it all here.*/
        public void Level1()
        {
            hero.SetPosA(titler.Left, titler.Bottom);
        }
        public void Level2()
        {

        }
    }
}
