VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   8730
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10455
   LinkTopic       =   "Form1"
   ScaleHeight     =   8730
   ScaleWidth      =   10455
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox Check1 
      Caption         =   "Show fuzzy corner check"
      Height          =   375
      Index           =   2
      Left            =   4200
      TabIndex        =   15
      Top             =   1560
      Width           =   2415
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Show direction indicators"
      Height          =   375
      Index           =   1
      Left            =   4200
      TabIndex        =   14
      Top             =   1200
      Width           =   2415
   End
   Begin VB.Frame Frame2 
      Caption         =   "Last sensor position "
      Height          =   1695
      Left            =   6720
      TabIndex        =   12
      Top             =   240
      Width           =   3495
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Height          =   195
         Index           =   4
         Left            =   240
         TabIndex        =   16
         Top             =   1200
         Width           =   2970
      End
      Begin VB.Label Label1 
         Alignment       =   2  'Center
         Height          =   195
         Index           =   3
         Left            =   240
         TabIndex        =   13
         Top             =   480
         Width           =   2970
      End
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Leave a trail"
      Height          =   375
      Index           =   0
      Left            =   4200
      TabIndex        =   6
      Top             =   840
      Width           =   2415
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Draw object"
      Height          =   495
      Left            =   4200
      TabIndex        =   5
      Top             =   240
      Width           =   2415
   End
   Begin VB.PictureBox Picture1 
      FillStyle       =   0  'Solid
      Height          =   6375
      Left            =   240
      ScaleHeight     =   421
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   661
      TabIndex        =   10
      Top             =   2160
      Width           =   9975
      Begin VB.Shape Shape2 
         Height          =   1095
         Left            =   5160
         Shape           =   4  'Rounded Rectangle
         Top             =   3960
         Visible         =   0   'False
         Width           =   255
      End
      Begin VB.Shape Shape1 
         Height          =   255
         Left            =   5880
         Shape           =   4  'Rounded Rectangle
         Top             =   1560
         Visible         =   0   'False
         Width           =   1095
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Settings "
      Height          =   1875
      Left            =   60
      TabIndex        =   7
      Top             =   120
      Width           =   3975
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   4
         Left            =   1320
         TabIndex        =   4
         Text            =   "50"
         Top             =   1200
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   3
         Left            =   3240
         TabIndex        =   3
         Text            =   "250"
         Top             =   720
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   2
         Left            =   2280
         TabIndex        =   2
         Text            =   "300"
         Top             =   720
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   1
         Left            =   3240
         TabIndex        =   1
         Text            =   "150"
         Top             =   300
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   0
         Left            =   2280
         TabIndex        =   0
         Text            =   "150"
         Top             =   300
         Width           =   615
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Sensor radius "
         Height          =   195
         Index           =   2
         Left            =   240
         TabIndex        =   11
         Top             =   1260
         Width           =   1005
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Rectangle Bottom-right    X=                  Y="
         Height          =   195
         Index           =   1
         Left            =   240
         TabIndex        =   9
         Top             =   780
         Width           =   3000
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Rectangle Top-left          X=                  Y="
         Height          =   195
         Index           =   0
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   2970
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Top-left and bottom-right coordinates of the rectangle.
Dim X1 As Long, Y1 As Long, X2 As Long, Y2 As Long
' Radius of the semicircle on top (half the X1-X2 distance)
Dim XR As Long

' Coordinates and Radius of the "sensor"
Dim SX As Long, SY As Long, SR As Long

' This just indicates whether we have drawn the "object" yet.
Dim ObjectExists As Boolean


' Some flags the user can set on the fly to determine behaviour...


' Whether to leave an "echo" as the sensor moves around.
Dim LeaveATrail As Boolean

' Whether to draw little rectangles indicating whether sensor
' is left, right, above or below the rectangle.
Dim ShowDirections As Boolean


' Whether to draw a line to show the distance which is calculated
' from the corners of the rectange to the centre of the sensor.
Dim ShowDistance As Boolean




Private Sub Check1_Click(Index As Integer)
  
  ' Toggle options on/off based on the checkbox array.
  
  Dim NewSetting As Boolean
  NewSetting = (Check1(Index).Value <> 0)
  Select Case Index
    Case 0 ' Trail display
      LeaveATrail = NewSetting
    Case 1 '
      ShowDirections = NewSetting
      Shape1.Visible = False
      Shape2.Visible = False
    Case 2
      ShowDistance = NewSetting
  End Select
End Sub

Private Sub Command1_Click()
  ' When the command button is clicked, set the
  ' size of the object, and draw it.
  X1 = Val(Text1(0))
  Y1 = Val(Text1(1))
  X2 = Val(Text1(2))
  Y2 = Val(Text1(3))
  SR = Val(Text1(4))
  DrawObject
  
  
End Sub



Private Sub DrawObject()

  With Picture1
    .AutoRedraw = True
  'picture1.FillStyle=
    .Cls
    .FillColor = 0&
    Picture1.Line (X1, Y1)-(X2, Y2), , BF
    'Dim R As Single
    XR = (X2 - X1) \ 2
    '.FillStyle = 7
    Picture1.Circle (X1 + XR, Y1), XR
    .AutoRedraw = False
  End With
  
  ObjectExists = True
  
  
End Sub

Private Sub Form_Load()
  SR = 50
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Static Busy As Boolean, Colour As Long
  If Not Busy Then
    Busy = True
    SX = X
    SY = Y
    If ObjectExists Then
      If CollisionDetected() Then
        Colour = RGB(255, 0, 0)
      Else
        Colour = RGB(0, 255, 0)
      End If
      Picture1.FillColor = Colour
      If Not LeaveATrail Then
        Picture1.Cls
      End If
      Picture1.Circle (SX, SY), SR
      DoEvents
    End If
    Busy = False
  End If
End Sub

Private Sub Text1_GotFocus(Index As Integer)
  With Text1(Index)
    .SelStart = 0
    .SelLength = 100
  End With
  
End Sub


Private Function CollisionDetected_Old() As Boolean


  ' Detect collision with the semicircle on top. For
  ' simplicity, we'll just check the full circle.
  ' Calculate the distance between the centre of the sensor
  ' and the centre of the (semi)circle.
  ' If that distance is less than the two radii added together,
  ' then I guess they overlap.
  
  Dim D As Long
  Dim DX As Single, DY As Single
   
  DX = Abs(X1 + XR - SX)
  DY = Abs(Y1 - SY)
  D = Sqr(DX ^ 2 + DY ^ 2)
  If D <= (SR + XR) Then
    CollisionDetected_Old = True
    Exit Function
  End If
  

  ' Detect collision with the rectangle.
  If SX + SR >= X1 And SX - SR <= X2 Then
    If SY + SR >= Y1 And SY - SR <= Y2 Then
      CollisionDetected_Old = True
    End If
  End If

  Dim SensorRightStatus  As Long, SensorLeftStatus As Long
  Dim SensorBottomStatus  As Long, SensorTopStatus As Long
  SensorRightStatus = Sgn(SX + SR - X1)
  SensorLeftStatus = Sgn(SX - SR - X2)
  SensorBottomStatus = Sgn(SY + SR - Y1)
  SensorTopStatus = Sgn(SY - SR - Y2)
  Debug.Print SensorRightStatus, SensorLeftStatus _
        , SensorBottomStatus, SensorTopStatus
  If ShowDirections Then
    With Shape1
      If SensorRightStatus < 0 Then
        ' We are to the left of the rectangle
        .Move X1 - XR * 1.5, (Y1 + (Y2 - Y1) \ 2)
        .Visible = True
      ElseIf SensorLeftStatus > 0 Then
        ' We are to the right of the rectangle
        .Move X2 + XR * 1.5 - .Width, (Y1 + (Y2 - Y1) \ 2)
        .Visible = True
      Else
        ' We are horizontally overlapping the rectangle
        .Visible = False
      End If
    End With
    
    With Shape2
      If SensorBottomStatus < 0 Then
        ' We are above the rectangle
        .Move X1 + XR, Y1 - XR * 1.5 - .Height
        .Visible = True
      ElseIf SensorTopStatus > 0 Then
        ' We are below the rectangle
        .Move X1 + XR, Y2 + XR * 1.5
        .Visible = True
      Else
        ' We are horizontally overlapping the rectangle
        .Visible = False
      End If
    End With
  End If
  
  
  Dim NeedToCheckCorner As Boolean
  Dim SensorStatusX As Long, SensorStatusY As Long
  Dim CornerToCheckX As Long, CornerToCheckY As Long
  Dim DistanceFromCorner As Long
  NeedToCheckCorner = False
  If SX > X2 Then
    ' We're to the right
    If SY < Y1 Then
      ' We're above and to the right. Check top-right corner.
      CornerToCheckX = X2
      CornerToCheckY = Y1
      NeedToCheckCorner = True
    ElseIf SY > Y2 Then
      ' We're below and to the right. Check bottom-right corner.
      CornerToCheckX = X2
      CornerToCheckY = Y2
      NeedToCheckCorner = True
    End If
  ElseIf SX < X1 < 0 Then
    ' We're to the left.
    If SY < Y1 Then
      ' We're above and to the left. Check top-left corner.
      CornerToCheckX = X1
      CornerToCheckY = Y1
      NeedToCheckCorner = True
    ElseIf SY > Y2 Then
      ' We're below and to the left. Check bottom-left corner.
      CornerToCheckX = X1
      CornerToCheckY = Y2
      NeedToCheckCorner = True
    End If
  End If
  
  If NeedToCheckCorner Then
    If ShowDistance Then
      Picture1.Line (CornerToCheckX, CornerToCheckY)-(SX, SY)
      DoEvents
    End If
    DistanceFromCorner = Sqr(((CornerToCheckX - SX) ^ 2) + ((CornerToCheckY - SY) ^ 2))
    Debug.Print "Distance from corner:"; DistanceFromCorner
    If DistanceFromCorner > SR Then
      CollisionDetected_Old = False
    End If
  End If

End Function




Private Function CollisionDetected() As Boolean


  Dim strStatus As String
  Label1(4).Caption = ""
  ShowStatus ""

  ' First up, I'll calculate some values which are likely to be used
  ' all over the place.
  ' Note that this is for convenience in coding - it may or may not
  ' affect efficiency.

  ' The extreme topmost, leftmost, bottommost and rightmost
  ' coordinates reached by the sensor.
  Dim SensorLeft As Long, SensorRight As Long
  Dim SensorTop As Long, SensorBottom As Long
  SensorLeft = SX - SR    ' Leftmost point of sensor
  SensorRight = SX + SR   ' Rightmost horizontal point of sensor
  SensorTop = SY - SR     ' Topmost horizontal point of sensor
  SensorBottom = SY + SR  ' Bottommost horizontal point of sensor

  ' No need to calculate these for the rectangle, as we already
  ' have them in X1, X2, Y1 and Y2 respectively.

  ' The centre-point of the rectangle, X/Y coordinates.
  ' Note that this really should be calculated only once, when
  ' the object is drawn.
  Dim RectangleCentreX As Long, RectangleCentreY As Long
  RectangleCentreX = X1 + (X2 - X1) \ 2
  RectangleCentreY = Y1 + (Y2 - Y1) \ 2
  
  
  ' The "status" (probably a bad term for it) of the sensor in
  ' relation to the rectangle, horizontally and vertically.
  ' That is, whether the sensor is...
  '    To the left of the rectangle, to the right, or overlapping horizontally.
  '    Above the rectangle, below it, or overlapping vertically.
  Dim SensorStatusHoriz As Long
  Dim SensorStatusVert As Long
  
  If SensorRight < X1 Then
    SensorStatusHoriz = -1
  ElseIf SensorLeft > X2 Then
    SensorStatusHoriz = 1
  Else
    SensorStatusHoriz = 0
  End If

  If SensorBottom < Y1 Then
    SensorStatusVert = -1
  ElseIf SensorTop > Y2 Then
    SensorStatusVert = 1
  Else
    SensorStatusVert = 0
  End If


  ' Just for fun, let's display an indicator to show
  ' where the sensor is...
  Select Case SensorStatusHoriz
    Case -1 ' Left.
      Select Case SensorStatusVert
        Case -1
          strStatus = "Above/left of the rectangle"
        Case 1
          strStatus = "Below/left of the rectangle"
        Case Else
          strStatus = "Left of the rectangle"
      End Select
    Case 1  ' Right.
      Select Case SensorStatusVert
        Case -1
          strStatus = "Above/right of the rectangle"
        Case 1
          strStatus = "Below/right of the rectangle"
        Case Else
          strStatus = "Right of the rectangle"
      End Select
    Case Else ' Horizontal overlap.
      Select Case SensorStatusVert
        Case -1
          strStatus = "Above the rectangle"
        Case 1
          strStatus = "Below the rectangle"
        Case Else
          strStatus = "Overlapping rectangle both ways."
      End Select
  End Select


  ' Detect collision with the semicircle on top. For
  ' simplicity, we'll just check the full circle.
  ' Calculate the distance between the centre of the sensor
  ' and the centre of the (semi)circle.
  ' If that distance is less than the two radii added together,
  ' then I guess they overlap.
  
  Dim DX As Single, DY As Single, Distance As Long
  
  ' We could calculate the distance in one go, but breaking it down makes
  ' it simpler to read.
  DX = (RectangleCentreX - SX) ' Horizontal component of distance
  DY = (Y1 - SY)               ' Vertical component of distance.
  ' Use Pythagorus' theorem to calculate the distance between centre points.
  Distance = Sqr(DX ^ 2 + DY ^ 2)
  If Distance <= (SR + XR) Then
    CollisionDetected = True  ' (Not really necessary, False is the default.)
    ShowStatus "Touching (semi-)circle"
    Exit Function
  End If
  
  
  Debug.Print SensorStatusHoriz, SensorStatusVert
  
  ' Show the indicators of which direction the sensor is from the rectangle.
  If ShowDirections Then
    With Shape1
      If SensorStatusHoriz < 0 Then
        ' We are to the left of the rectangle
        .Move X1 - XR * 1.5, RectangleCentreY - .Height \ 2
        .Visible = True
      ElseIf SensorStatusHoriz > 0 Then
        ' We are to the right of the rectangle
        .Move X2 + XR * 1.5, RectangleCentreY - .Height \ 2
        .Visible = True
      Else
        ' We are horizontally overlapping the rectangle
        .Visible = False
      End If
    End With
    
    With Shape2
      If SensorStatusVert < 0 Then
        ' We are above the rectangle
        .Move RectangleCentreX - .Width \ 2, Y1 - XR * 1.5 - .Height
        .Visible = True
      ElseIf SensorStatusVert > 0 Then
        ' We are below the rectangle
        .Move RectangleCentreX - .Width \ 2, Y2 + XR * 1.5
        .Visible = True
      Else
        ' We are horizontally overlapping the rectangle
        .Visible = False
      End If
    End With
  End If
  
  
  
  ' Ok, now to detect whether our sensor is overlapping the rectangle.
  
  
  If SensorStatusHoriz = 0 And SensorStatusVert = 0 Then
    ' We have overlap on both axes.
    CollisionDetected = True ' That was easy, wasn't it?
    
    ' Now we have to take care of the fuzzy areas around the corners.
  
    Dim NeedToCheckCorner As Boolean
    'Dim SensorStatusX As Long, SensorStatusY As Long
    Dim CornerX As Long, CornerY As Long
    Dim DistanceFromCorner As Long
    NeedToCheckCorner = False
    If SX > X2 Then
      ' We're to the right
      If SY < Y1 Then
        ' We're above and to the right. Check top-right corner.
        CornerX = X2
        CornerY = Y1
        NeedToCheckCorner = True
      ElseIf SY > Y2 Then
        ' We're below and to the right. Check bottom-right corner.
        CornerX = X2
        CornerY = Y2
        NeedToCheckCorner = True
      End If
    ElseIf SX < X1 Then
      ' We're to the left.
      If SY < Y1 Then
        ' We're above and to the left. Check top-left corner.
        CornerX = X1
        CornerY = Y1
        NeedToCheckCorner = True
      ElseIf SY > Y2 Then
        ' We're below and to the left. Check bottom-left corner.
        CornerX = X1
        CornerY = Y2
        NeedToCheckCorner = True
      End If
    End If
    
    If NeedToCheckCorner Then
      If ShowDistance Then
        Picture1.Line (CornerX, CornerY)-(SX, SY)
        DoEvents
      End If
      DistanceFromCorner = Sqr(((CornerX - SX) ^ 2) + ((CornerY - SY) ^ 2))
      Debug.Print "Distance from corner:"; DistanceFromCorner
      Label1(4).Caption = Format(DistanceFromCorner) & " units from corner"
      If DistanceFromCorner > SR Then
        CollisionDetected = False
        Label1(4) = Label1(4) & " (not touching)"
      End If
    End If
  End If

  ShowStatus strStatus

End Function



Private Sub ShowStatus(ByVal What As String)

  Label1(3).Caption = What
  
  ' Ok, so the Sub doesn't do much. Sue me!
  
End Sub
