VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6645
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8220
   LinkTopic       =   "Form1"
   ScaleHeight     =   6645
   ScaleWidth      =   8220
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Draw object"
      Height          =   495
      Left            =   5580
      TabIndex        =   8
      Top             =   300
      Width           =   1455
   End
   Begin VB.PictureBox Picture1 
      FillStyle       =   0  'Solid
      Height          =   4335
      Left            =   240
      ScaleHeight     =   285
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   517
      TabIndex        =   7
      Top             =   2160
      Width           =   7815
   End
   Begin VB.Frame Frame1 
      Caption         =   "Frame1"
      Height          =   1875
      Left            =   60
      TabIndex        =   0
      Top             =   120
      Width           =   4935
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   3
         Left            =   3240
         TabIndex        =   6
         Text            =   "300"
         Top             =   840
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   2
         Left            =   2280
         TabIndex        =   5
         Text            =   "400"
         Top             =   840
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   1
         Left            =   3240
         TabIndex        =   3
         Text            =   "150"
         Top             =   300
         Width           =   615
      End
      Begin VB.TextBox Text1 
         Height          =   345
         Index           =   0
         Left            =   2280
         TabIndex        =   2
         Text            =   "150"
         Top             =   300
         Width           =   615
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Rectangle Bottom-right    X=                  Y="
         Height          =   195
         Index           =   1
         Left            =   240
         TabIndex        =   4
         Top             =   900
         Width           =   3000
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Rectangle Top-left          X=                  Y="
         Height          =   195
         Index           =   0
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Width           =   2970
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Top-left and bottom-right coordinates of the rectangle.
Dim X1 As Long, Y1 As Long, X2 As Long, Y2 As Long
' Radius of the semicircle on top (half the X1-X2 distance)
Dim XR As Long

' Coordinates and Radius of the "sensor"
Dim SX As Long, SY As Long, SR As Long



Dim ObjectExists As Boolean




Private Sub Command1_Click()
  
  X1 = Val(Text1(0))
  Y1 = Val(Text1(1))
  X2 = Val(Text1(2))
  Y2 = Val(Text1(3))
  DrawObject
  
  
End Sub



Private Sub DrawObject()

  Picture1.AutoRedraw = True
  'picture1.FillStyle=
  Picture1.Cls
  Picture1.FillColor = 0&
  Picture1.Line (X1, Y1)-(X2, Y2), , BF
  'Dim R As Single
  XR = (X2 - X1) \ 2
  Picture1.Circle (X1 + XR, Y1), XR
  Picture1.AutoRedraw = False
  
  ObjectExists = True
  
  
End Sub

Private Sub Form_Load()
  SR = 10
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  Static Busy As Boolean, Colour As Long
  If Not Busy Then
    Busy = True
    SX = X
    SY = Y
    If ObjectExists Then
      If CollisionDetected() Then
        Colour = RGB(255, 0, 0)
      Else
        Colour = RGB(0, 255, 0)
      End If
      Picture1.FillColor = Colour
      'Picture1.Cls
      Picture1.Circle (SX, SY), SR
      DoEvents
    End If
    Busy = False
  End If
End Sub

Private Sub Text1_GotFocus(Index As Integer)
  With Text1(Index)
    .SelStart = 0
    .SelLength = 100
  End With
  
End Sub


Private Function CollisionDetected() As Boolean


  ' Detect collision with the semicircle on top. For
  ' simplicity, we'll just check the full circle.
  ' Calculate the distance between the centre of the sensor
  ' and the centre of the (semi)circle.
  ' If that distance is less than the two radii added together,
  ' then I guess they overlap.
  
  Dim D As Long
  Dim DX As Single, DY As Single
   
  DX = Abs(X1 + XR - SX)
  DY = Abs(Y1 - SY)
  D = Sqr(DX ^ 2 + DY ^ 2)
  If D <= (SR + XR) Then
    CollisionDetected = True
    Exit Function
  End If
  


  ' Detect collision with the rectangle.
  If SX + SR >= X1 And SX - SR <= X2 Then
    If SY + SR >= Y1 And SY - SR <= Y2 Then
      CollisionDetected = True
    End If
  End If

End Function
